﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Projekt
{
    
    public partial class HeldErstellen : UserControl
    {
        
        int zaehler; //fuer Auswahl der Bilder in picturebox noetig
        
        public int Zaehler
        {
            get { return zaehler; }
            set { zaehler = value; }
        }

        
        
        public HeldErstellen() //Konstruktor (dynamisch nach Hero.Gender(enum))       
        {
            
            InitializeComponent();
            foreach (string str in StaticCollect.Held.GetAllGenderNames())
            {
                listBox_gender.Items.Add(str);
            }
            avatar("smiley");

            button_ok.Enabled = false;
            button_next_avatar.Enabled = false;
        }


        
        private void button_reset_Click(object sender, EventArgs e) //Clickevent: reset
        {
            textBox_name.Clear();
            avatar("smiley");
            Zaehler = 0;
            button_ok.Enabled = false;
            label_reset.Visible = true;
        }

        
        private void button_ok_Click(object sender, EventArgs e) //Clickevent: Held anlegen
        {
            if (textBox_name.Text == string.Empty)
            {
                MessageBox.Show("Namen eingeben!", "Fehler");

            }
            else
            {
                StaticCollect.Held.Name = textBox_name.Text;
                StaticCollect.Held.Anlegen();
                StaticCollect.Held.Gender = listBox_gender.SelectedItem.ToString();
                StaticCollect.Held.Avatarfile = listBox_gender.SelectedItem.ToString() + Zaehler;
                StaticCollect.Held.HeroQuickSave(textBox_name.Text);
                button_ok.Enabled = false;
                close();
                
                }
        }

        
        
        private void listBox_gender_SelectedIndexChanged(object sender, EventArgs e) //listbox dynamisch nach Hero.Gender (enum) erzeugt
        {
            label_reset.Visible = false;
            button_ok.Enabled = true;
            button_next_avatar.Enabled = true;
            Zaehler = 1;
            string auswahl = listBox_gender.SelectedItem.ToString() + Zaehler;
            avatar(auswahl);

        }

        
        public void avatar(string name) //picturebox dynamisch (nach NameZahl . jpg) mit Bild
        {
            if (Bilder.ResourceManager.GetObject(string.Empty) == Bilder.ResourceManager.GetObject(name))
            {
                Zaehler = 1;
                name = listBox_gender.SelectedItem.ToString() + Zaehler;
            }
            Image avatar = Bilder.ResourceManager.GetObject(name) as Bitmap;
            pictureBox_avatar.SizeMode = PictureBoxSizeMode.Zoom;
            pictureBox_avatar.Image = avatar;
        }

        private void button_next_avatar_Click(object sender, EventArgs e) //Clickevent: naechsrtes Bild
        {
            Zaehler++;
           
            string auswahl = listBox_gender.SelectedItem.ToString() + Zaehler;
            avatar(auswahl);
            
        }

        private void button_close_Click(object sender, EventArgs e)
        {
            close();
        }

        private void close()
        {
            (this.Parent as Form1).MenuEnable();
            (this.Parent as Form).Controls.Remove(this);
        }

        private void button_close_Click_1(object sender, EventArgs e)
        {
            close();
        }



        
        
        

        
    }
}
