﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Projekt
{
    /// <summary>
    /// Control um neuen Raum anzulegen
    /// </summary>
    public partial class LevelEditor : UserControl
    {
        Mesh mesh = new Mesh();
       
        bool[] wall=new bool[Enum.GetNames(typeof(StaticCollect.EXPOSITION)).Length]; //dynamisches anlegen (enum EXPOSITION)
        int stringzaehler=0; //merkt sich wie viele Strings eingegeben werden sollen
        string[] text; //merkt sich die eingegebenen strings
        string[] exposition = Enum.GetNames(typeof(StaticCollect.EXPOSITION));//dynamisches anlegen (enum EXPOSITION)
        
        
        public LevelEditor()
        {
            InitializeComponent();
            foreach (string exp in exposition)
            {
                checkedListBox_wall.Items.Add(exp);

            }
            listBox_monster.Enabled = false;

            
            
            foreach (string str in StaticCollect.Currentmesh.Monster.GetAllMonsterNames())
            {
                listBox_monster.Items.Add(str);
            }



            
            

        }
      
        private void button_string_benoetigt_Click(object sender, EventArgs e) //Clickevent ok
        {
            
            numericUpDown_anz.Enabled = false;
            if (!((int)numericUpDown_anz.Value == 0))
            {
                groupBox3.Visible = true;
                text = new string[(int)numericUpDown_anz.Value];
            }
            
        }

        private void button_reset_Click(object sender, EventArgs e) //Clickevent reset
        {
            this.LevelEditorUpdate();
        }

        private void button_ok_Click(object sender, EventArgs e) //Clickevent anlegen
        {
            if (text == null)
            {
                text = new string[1];
                text[0] = "nichts interessantes hier";
            }
            StaticCollect.Currentmesh.Textausgabe = text;
            

            StaticCollect.Currentmesh.MeshQuickSave();
            this.LevelEditorUpdate();
            MessageBox.Show("Raum angelegt", "alles in Ordnung");
            
        }

        private void button_string_Click(object sender, EventArgs e) //Clickevent string setzen
        {
            
            label_string.Text = "String Nr. " + (stringzaehler+2) +":";
            text[stringzaehler] = textBox_string.Text;
            stringzaehler++;
            textBox_string.Text = string.Empty;
            if (stringzaehler >= text.Length)
            {
                button_string.Enabled = false;
                groupBox3.Visible = false;
            }
           
        }

        private void button_close_Click(object sender, EventArgs e) //clickevent close
        {
            (this.Parent as Form).Controls.Remove(this);
        }


        private void checkedListBox_wall_SelectedIndexChanged(object sender, EventArgs e)
        {

           
            //check ob Mauer im existiert um Tuer einzufuegen
            if (!checkedListBox_wall.GetItemChecked((int)StaticCollect.EXPOSITION.north) && checkedListBox_wall.GetItemChecked((int)StaticCollect.EXPOSITION.doornorth))
            {
                MessageBox.Show("Tuer kann nur eingefuegt werden, falls eine Mauer im Norden existiert", "keine Mauer");
                checkedListBox_wall.SetItemChecked((int)StaticCollect.EXPOSITION.doornorth, false);
            }

            if (!checkedListBox_wall.GetItemChecked((int)StaticCollect.EXPOSITION.south) && checkedListBox_wall.GetItemChecked((int)StaticCollect.EXPOSITION.doorsouth))
            {
                MessageBox.Show("Tuer kann nur eingefuegt werden, falls eine Mauer im Sueden existiert", "keine Mauer");
                checkedListBox_wall.SetItemChecked((int)StaticCollect.EXPOSITION.doorsouth, false);
            }
            
            
            for (int i = 0; i < checkedListBox_wall.Items.Count; i++)
            {
                wall[i] = checkedListBox_wall.GetItemChecked(i);
            }
            StaticCollect.Currentmesh.Wall = wall;

            CheckMeshesAroundCurrentMesh();
            
            
            (this.Parent as Form1).GrafikUpdate(StaticCollect.Currentmesh.Monster.Avatarfile);
        }

        public void LevelEditorUpdate()
        {   
            int index = 0;
            listBox_monster.Enabled = false;
            checkBox_monster.Checked = false;

            
            if(StaticCollect.MeshExists())
            {
                
                StaticCollect.LoadMesh();
                
                foreach (bool bo in StaticCollect.Currentmesh.Wall)
                {
                    checkedListBox_wall.SetItemChecked(index, bo);
                    index++;
                }
                
                

            }

            else
            {
                
                foreach(bool bo in StaticCollect.Currentmesh.Wall)
                {
                    checkedListBox_wall.SetItemChecked(index, false);
                    StaticCollect.Currentmesh.Wall[index] = false;
                    index++;
                }
            }

           
            label_string.Text = "String Nr. 1:";
            groupBox3.Visible = false;
            button_string.Enabled = true;
            numericUpDown_anz.Enabled = true;
            stringzaehler = 0;
            this.label_XCoordinate.Text = "X-Koordinate: " + StaticCollect.Currentmesh.CoordinateX;
            this.label_YCoordinate.Text = "Y-Koordinate: " + StaticCollect.Currentmesh.CoordinateY;
            CheckMeshesAroundCurrentMesh();
            
            (this.Parent as Form1).GrafikUpdate(StaticCollect.Currentmesh.Monster.Avatarfile);
            
        }

        void CheckMeshesAroundCurrentMesh()
        {
            foreach (string exp in Enum.GetNames(typeof(StaticCollect.EXPOSITION)))
            {   int x=0;
                int y=0;
                switch(exp)
                {
                    case "north":
                        {
                            y++;
                            if (mesh.MeshExists(StaticCollect.Currentmesh.CoordinateX + x, StaticCollect.Currentmesh.CoordinateY + y))
                            {
                                mesh = mesh.MeshQuickLoad(StaticCollect.Currentmesh.CoordinateX + x, StaticCollect.Currentmesh.CoordinateY + y);
                                StaticCollect.Currentmesh.Wall[(int)StaticCollect.EXPOSITION.north] = mesh.Wall[(int)StaticCollect.EXPOSITION.south];
                                checkedListBox_wall.SetItemChecked((int)StaticCollect.EXPOSITION.north, mesh.Wall[(int)StaticCollect.EXPOSITION.south]);
                                StaticCollect.Currentmesh.Wall[(int)StaticCollect.EXPOSITION.doornorth] = mesh.Wall[(int)StaticCollect.EXPOSITION.doorsouth];
                                checkedListBox_wall.SetItemChecked((int)StaticCollect.EXPOSITION.doornorth, mesh.Wall[(int)StaticCollect.EXPOSITION.doorsouth]);
                            }
                            break;
                        }
                    case "south":
                        {
                            y--;
                            if (mesh.MeshExists(StaticCollect.Currentmesh.CoordinateX + x, StaticCollect.Currentmesh.CoordinateY + y))
                            {
                                mesh = mesh.MeshQuickLoad(StaticCollect.Currentmesh.CoordinateX + x, StaticCollect.Currentmesh.CoordinateY + y);
                                StaticCollect.Currentmesh.Wall[(int)StaticCollect.EXPOSITION.south] = mesh.Wall[(int)StaticCollect.EXPOSITION.north];
                                checkedListBox_wall.SetItemChecked((int)StaticCollect.EXPOSITION.south, mesh.Wall[(int)StaticCollect.EXPOSITION.north]);
                                StaticCollect.Currentmesh.Wall[(int)StaticCollect.EXPOSITION.doorsouth] = mesh.Wall[(int)StaticCollect.EXPOSITION.doornorth];
                                checkedListBox_wall.SetItemChecked((int)StaticCollect.EXPOSITION.doorsouth, mesh.Wall[(int)StaticCollect.EXPOSITION.doornorth]);
                            } 
                            break;
                        }
                    case "west":
                        {
                            x--;
                            if (mesh.MeshExists(StaticCollect.Currentmesh.CoordinateX + x, StaticCollect.Currentmesh.CoordinateY + y))
                            {
                                mesh = mesh.MeshQuickLoad(StaticCollect.Currentmesh.CoordinateX + x, StaticCollect.Currentmesh.CoordinateY + y);
                                StaticCollect.Currentmesh.Wall[(int)StaticCollect.EXPOSITION.west] = mesh.Wall[(int)StaticCollect.EXPOSITION.east];
                                checkedListBox_wall.SetItemChecked((int)StaticCollect.EXPOSITION.west, mesh.Wall[(int)StaticCollect.EXPOSITION.east]);
                            } 
                            break;
                        }
                    case "east":
                        {
                            x++;
                            if (mesh.MeshExists(StaticCollect.Currentmesh.CoordinateX + x, StaticCollect.Currentmesh.CoordinateY + y))
                            {
                                mesh = mesh.MeshQuickLoad(StaticCollect.Currentmesh.CoordinateX + x, StaticCollect.Currentmesh.CoordinateY + y);
                                StaticCollect.Currentmesh.Wall[(int)StaticCollect.EXPOSITION.east] = mesh.Wall[(int)StaticCollect.EXPOSITION.west];
                                checkedListBox_wall.SetItemChecked((int)StaticCollect.EXPOSITION.east, mesh.Wall[(int)StaticCollect.EXPOSITION.west]);
                            }
                            break;
                        }

                    default: continue; 
                }
                
            }
        }

        private void checkBox_monster_CheckedChanged(object sender, EventArgs e)
        {
            
                if (checkBox_monster.Checked)
                {
                    listBox_monster.Enabled = true;

                }
                else
                {
                    listBox_monster.Enabled = false;
                    StaticCollect.Currentmesh.Monster = new Monster();
                    (this.Parent as Form1).GrafikUpdate(string.Empty);
                }
            
        }

        private void listBox_monster_SelectedIndexChanged(object sender, EventArgs e)
        {
            
            
               StaticCollect.Currentmesh.Monster = StaticCollect.Currentmesh.Monster.MonsterQuickLoad(listBox_monster.SelectedItem.ToString());
               (this.Parent as Form1).GrafikUpdate(StaticCollect.Currentmesh.Monster.Avatarfile);
            
            
        }

        private void button_close_Click_1(object sender, EventArgs e)
        {
            Close();
        }

        private void Close()
        {
            (this.Parent as Form1).MenuEnable();
            (this.Parent as Form1).DefaultScreen();
        }



        

        



    }
}
