﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Projekt
{
    public partial class SpielFenster : UserControl
    {
        
        public SpielFenster()
        {
            InitializeComponent();
            
        }

        
        public void SetLeftWall()
        {
            if (StaticCollect.Currentmesh.Wall[(int)StaticCollect.EXPOSITION.west])
                SetGrafik("wall_left", pictureBox_left);
            else
                SetGrafik(string.Empty, pictureBox_left);
            
        }

        public void SetRightWall()
        {
            if (StaticCollect.Currentmesh.Wall[(int)StaticCollect.EXPOSITION.east])
                SetGrafik("wall_right", pictureBox_right);
            else
                SetGrafik(string.Empty, pictureBox_right);

        }

        public void SetFrontWall()
        {
            if (StaticCollect.Currentmesh.Wall[(int)StaticCollect.EXPOSITION.north])
                SetGrafik("wall", pictureBox_up);
            else
                SetGrafik(string.Empty, pictureBox_up);

        }

        public void SetDoor()
        {
            if (StaticCollect.Currentmesh.Wall[(int)StaticCollect.EXPOSITION.doornorth])
            {
                SetGrafik("door", pictureBox_door);
            }
            else
                SetGrafik(string.Empty, pictureBox_door);
            
        }

        public void SetDownGrafik(string grafik)
        {
            SetGrafik(grafik, pictureBox_down);
        }



        public void SetGrafik(string name, PictureBox pic)
        {
            Image grafik = Bilder.ResourceManager.GetObject(name) as Bitmap;
            pic.SizeMode = PictureBoxSizeMode.Zoom;
            pic.Image = grafik;
        }

        public void GrafikUpdate(string grafik)
        {
            SetLeftWall();
            SetRightWall();
            SetFrontWall();
            SetDoor();
            SetDownGrafik(grafik);
        }

       

       

        
        

        

        
        
    }
}
