﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Projekt
{   
    [Serializable]
    public class Story
    {

        public Story()
        {
            Xcoord = StaticCollect.Currentmesh.CoordinateX;
            Yccord = StaticCollect.Currentmesh.CoordinateY;
        }
    
        //------------------------------------------------------------------
        //------------------------ Koordinaten des Meshes mit der Story -----
        //-------------------------------------------------------------------
        int level;

        public int Level
        {
            get { return level; }
            set { level = value; }
        }

        int room;

        public int Room
        {
            get { return room; }
            set { room = value; }
        }

        int xcoord;

        public int Xcoord
        {
            get { return xcoord; }
            set { xcoord = value; }
        }

        int yccord;

        public int Yccord
        {
            get { return yccord; }
            set { yccord = value; }
        }


        
        //------------------------------------------------------------
        //------------------- Story im Spielverlauf -----------------
        //-----------------------------------------------------------
        int x = StaticCollect.Held.CoordinateX;
        int y = StaticCollect.Held.CoordinateY;
        public void EnterMesh()
        {
            
            if (StaticCollect.Held.Mem.GetActionMem(x, y) <= Listmonster.Count)
            {
                Fight fight = new Fight();
                fight.FightAction(listmonster[StaticCollect.Held.Mem.GetActionMem(x, y)]);
            }
        }
        
        public void victory()
        {

            StaticCollect.Held.Inv.AddItem(listitem[StaticCollect.Held.Mem.GetActionMem(x, y)], listitem[StaticCollect.Held.Mem.GetActionMem(x, y)].Id);
            RaiseAction(x, y);
            RaiseString(x, y);
        }


        
        //---------------------------------------------------------------
        //---------------------- Story erzeugen ----------------------
        //---------------------------------------------------------------
        

        List<Monster> listmonster = new List<Monster>();

        public List<Monster> Listmonster
        {
            get { return listmonster; }
            set { listmonster = value; }
        }
        List<Item> listitem = new List<Item>();

        public List<Item> Listitem
        {
            get { return listitem; }
            set { listitem = value; }
        }
        
        public void Monster(Monster mon, Item item)
        {

            listmonster.Add(mon);
            listitem.Add(item);

        }



        
        
        
        
        //------------------------------------------------------------------
        //---------------- Memory Operationen -----------------------------
        //-----------------------------------------------------------------

       


        public void RaiseDoorKey(int x, int y)
        {
            StaticCollect.Held.Mem.SetDoorKey(x, y, true);
        }

        public void RaiseBoxKey(int x, int y)
        {
            StaticCollect.Held.Mem.SetBoxKey(x, y, true);
        }

        public void RaiseString(int x, int y)
        {
            StaticCollect.Held.Mem.SetStringMem(x, y, StaticCollect.Held.Mem.GetStringMem(x, y)+1);
        }

        public void RaiseAction(int x, int y)
        {
            StaticCollect.Held.Mem.SetActionMem(x, y, StaticCollect.Held.Mem.GetActionMem(x, y) + 1);
        }

        /// <summary>
        /// true falls eine Story stattfindet
        /// </summary>
        /// <param name="x"></param>
        /// <param name="y"></param>
        /// <returns></returns>
        public void Action(int x, int y)
        {
            if (this.listmonster.Count>StaticCollect.Held.GetCurrentMem())
            {
                GetStoryAction(x,y);

            }

            else
            {
                MessageBox.Show("keine story mehr");
            }
            
        }

        /// <summary>
        /// die storyline wird ausgeführt
        /// </summary>
        /// <param name="x"></param>
        /// <param name="y"></param>
        public void GetStoryAction(int x, int y)
        {
            Fight fight = new Fight();
            if (fight.FightAction(listmonster[StaticCollect.Held.GetCurrentMem()]))
            {
                StaticCollect.Held.Inv.AddItem(listitem[StaticCollect.Held.GetCurrentMem()], listitem[StaticCollect.Held.GetCurrentMem()].Id);
                RaiseAction(x, y);
            }

        }
        
        //------------------------------------------------------------------------
        //------------------------ Fileoperationen --------------------------------
        //-----------------------------------------------------------------------
        public void SaveStory(int xcoord, int ycoord)
        {
            FileTransfer.QuickSave<Story>(this, Application.StartupPath + "\\XmlFiles\\Story\\" + "story_" + xcoord + "_" + ycoord);
        }

        public Story LoadStory(int x, int y)
        {
            return FileTransfer.QuickLoad<Story>(Application.StartupPath + "\\XmLFiles\\Story\\" + "story_" + x + "_" + y);
        }

        public bool StoryExists(int x, int y) //check ob file existiert
        {
            return FileTransfer.FileExist(Application.StartupPath + "\\XmLFiles\\Story\\" + "story_" + x + "_" + y + ".xml");
        }

        
       
        
    }
}
