﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace TowerDefence.Derived
{
    class MyTowerFlak : TowerBase
    {
        [DescriptorProperty]
		public override float Speed { get { return 7f; } }
        [DescriptorProperty]
		public override float Range { get { return 5f; } }
        [DescriptorProperty]
        public override decimal Cost { get { return Math.Round(base.Cost / 4 + 1); } }
        [DescriptorProperty]
		public override ShotTypeDescriptor ShotType { get { return ShotTypeDescriptor.GetDescriptor(typeof(MyShotAir)); } }
        public override string NickName { get { return "SAM"; } }
        public override string Description { get { return "SAM! but kill's also everthing"; } }
        protected override string SpriteFile { get { return "MyTowerFlak.bmp"; } }
        protected override int[] FramesPerDirection { get { return new int[] { 1, 1, 1, 1 }; } }
        protected override int AnimationDelay { get { return 200; } }

        protected new static List<Animation.Animation> animations;

        public override List<UnitBase> Targets
        {
            get { return targets.Where(ub => ub.Strategy == MazeStrategy.Air).ToList(); }//shoots only on flying objects
            set { targets = value; }
        }
    }
}

