﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;

namespace TowerDefence
{
    public enum Direction
    {
        Right,
        Top,
        Left,
        Bottom,
    }

    public class Path
    {
        List<Point> list;

        public event EventHandler Ended;

        public Path(List<Point> list)
        {
            this.list = list;
        }

        public PointF Propagate(float pathLength, out Direction direction)
        {
            int lastIndex = (int)pathLength;

            if (lastIndex + 1 >= list.Count)
            {
                if (Ended != null)
                    Ended(this, EventArgs.Empty);
                direction = Direction.Right;
                return PointF.Empty;
            }

            if (list[lastIndex].X < list[lastIndex + 1].X)
                direction = Direction.Right;
            else if (list[lastIndex].X > list[lastIndex + 1].X)
                direction = Direction.Left;
            else if (list[lastIndex].Y > list[lastIndex + 1].Y)
                direction = Direction.Top;
            else
                direction = Direction.Bottom;

            return list[lastIndex].Add(list[lastIndex + 1].Subtract(list[lastIndex]).Scale(pathLength - lastIndex));
        }
    }
}
