﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Reflection;

namespace TowerDefence
{
    class WaveCollection
    {
        int currentIndex;

        Random rng;

        List<Wave> waves;

        static List<Type> unitsList = typeof(UnitBase).EnumerateDerivedTypes().OrderBy(t => UnitTypeDescriptor.GetDescriptor(t).Rating).ToList();

        public WaveCollection(bool synced = false)
        {
            waves = new List<Wave>();
            currentIndex = 0;
            rng = synced ? new Random(0) : new Random();
        }

        public Wave RandomWave()
        {
            Wave newWave = new Wave();

            int nUnits = rng.Next(Math.Max(currentIndex / 2, 1), currentIndex);
            newWave.PrizeMoney = nUnits;

            for (int i = 0; i < nUnits; i++)
            {
                Type unitType = unitsList[rng.Next(Math.Min(unitsList.Count, currentIndex / 7 + 1))];
                UnitBase unit = Assembly.GetExecutingAssembly().CreateInstance(unitType.FullName) as UnitBase;
                newWave.Add(unit, i == 0 ? 0 : (float)rng.NextDouble() * currentIndex / 4);
            }

            return newWave;
        }

        public Wave NextWave()
        {
            if (currentIndex < waves.Count)
                return waves[currentIndex++];
            else
            {
                currentIndex++;
                return RandomWave();
            }
        }

        public void AddTestWave<T>() where T : UnitBase, new()
        {
            Wave newWave = new Wave();

            newWave.Add(new T(), 0);
            newWave.Add(new T(), 1);
            for (int i = 0; i < 10; i++)
                newWave.Add(new T(), 2 + i / new T().Speed);

            waves.Add(newWave);
        }

        public void AddStandardWaves()
        {
            ////TODO: replace with sensible waves...
            //var unittypes = typeof(UnitBase).EnumerateDerivedTypes().OrderByDescending(o=>o.Name).ToArray();
            //for (int waveNumber = 0; waveNumber < unittypes.Length; waveNumber++)
            //{
            //    Wave newWave = new Wave();

            //    for (int i = 0; i < 16; i++)
            //    {
            //        UnitBase unit = Assembly.GetExecutingAssembly().CreateInstance(unittypes[waveNumber].FullName) as UnitBase;

            //        newWave.Add(unit, 2 * (float)Math.Sqrt((double)i));
            //    }

            //    newWave.PrizeMoney = waveNumber * 3;
            //    waves.Add(newWave);
            //}
        }
    }
}
