﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Drawing;

namespace Animation
{
    /// <summary>
    /// animated Sprite keeping track of its own animation state
    /// </summary>
    class Sprite
    {
        public Point Position;
        List<Animation> animations;
        Animation currentAnimation;
        public Bitmap CurrentFrame { get; private set; }
        int currentFrameID;
        public bool Visible { get; set; }
        public bool Animated { get; private set; }
        DateTime nextFrameChange;

        public Sprite()
        {
            Visible = false;
            Animated = false;
        }

        public Sprite(Point position, Bitmap frame)
        {
            Position = position;
            Visible = true;
            Animated = false;
            CurrentFrame = frame;
        }

        public Sprite(Point position, Animation animation)
        {
            Position = position;
            Visible = true;
            Animated = true;
            currentAnimation = animation;
            currentFrameID = 0;
            CurrentFrame = currentAnimation[currentFrameID];
        }

        public Sprite(Point position, List<Animation> animations)
        {
            Position = position;
            Visible = true;
            Animated = true;
            this.animations = animations;
            currentAnimation = this.animations[0];
            currentFrameID = 0;
            CurrentFrame = currentAnimation[currentFrameID];
            Z = 0;
        }

        public void AddAnimation(Animation animation)
        {
            animations.Add(animation);
        }

        public void SetAnimation(string animationName)
        {
            if (animations != null)
            {
                currentAnimation = animations.Where(a => { return a.Name == animationName; }).FirstOrDefault() ?? currentAnimation;
            }
        }

        void nextFrame()
        {
            currentFrameID++;
            if(currentFrameID >= currentAnimation.Length)
                currentFrameID = 0;
            CurrentFrame = currentAnimation[currentFrameID];
            nextFrameChange = DateTime.Now + currentAnimation.Period;
        }

        internal void Update(Graphics g)
        {
            if (Visible && Position != Point.Empty)
            {
                if (Animated && DateTime.Now > nextFrameChange)
                    nextFrame();
                Blit(g);
            }
        }

        private void Blit(Graphics g)
        {
            lock (CurrentFrame)
            {
                g.DrawImage(CurrentFrame, new Point(Position.X - CurrentFrame.Width / 2, Position.Y - CurrentFrame.Height / 2));
            }
        }

        public int Z { get; set; }
    }
}
