﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SdlDotNet.Core;
using System.Drawing;

namespace TowerDefence
{
    public class UnitBase : BaseObject
    {
        public Path Path { get; set; }

        [DescriptorProperty]
        public virtual int HitPoints { get { return 10; } }

        int hitPoints;

        public virtual MazeStrategy Strategy { get { return MazeStrategy.Air; } }

        public virtual int Damage { get { return 1; } }

        protected int creationTime;

        public class DiedEventArgs : EventArgs
        {
            public UnitBase DiedUnit { get; private set; }
            public DiedEventArgs(UnitBase diedUnit)
            {
                DiedUnit = diedUnit;
            }
        }

        public event EventHandler<DiedEventArgs> Died;

        public class AccomplishedEventArgs : EventArgs
        {
            public UnitBase SuccessfullUnit { get; private set; }
            public AccomplishedEventArgs(UnitBase successfullUnit)
            {
                SuccessfullUnit = successfullUnit;
            }
        }

        public event EventHandler<AccomplishedEventArgs> Accomplished;

        /// <summary>
        /// Constructs new UnitBase instance
        /// </summary>
        public UnitBase()
        {
            hitPoints = HitPoints;
            creationTime = int.MinValue;

            Direction = TowerDefence.Direction.Right;

            var newSpawnSound = this.GetType().getNewField("SpawnSound");
            if (newSpawnSound.GetValue(this) == null)
                newSpawnSound.SetValue(this, new Sound(SpawnSoundFile));

            var newDieSound = this.GetType().getNewField("DieSound");
            if (newDieSound.GetValue(this) == null)
                newDieSound.SetValue(this, new Sound(DieSoundFile));

            var newThroughSound = this.GetType().getNewField("ThroughSound");
            if (newThroughSound.GetValue(this) == null)
                newThroughSound.SetValue(this, new Sound(ThroughSoundFile));

            (newSpawnSound.GetValue(this) as Sound).Play();
        }

        public override void Update(TickEventArgs args)
        {
            if (creationTime == int.MinValue)
                creationTime = args.LastTick;

            base.Update(args);

            if ((Speed / 1000) > 0f)
            {
                Direction temp;
                MazeCoordinates = Path.Propagate((Speed / 1000) * (args.Tick - creationTime), out temp);
                if (MazeCoordinates == PointF.Empty)
                {
                    Dead = true;
                    (this.GetType().getNewField("ThroughSound").GetValue(this) as Sound).Play();
                    if (Accomplished != null)
                        Accomplished(this, new AccomplishedEventArgs(this));
                    return;
                }
                Direction = temp;
            }
        }

        public void Hit(ShotBase shot)
        {
            hitPoints -= shot.Damage;
            if (hitPoints < 0)
            {
                Dead = true;
                (this.GetType().getNewField("DieSound").GetValue(this) as Sound).Play();
                if (Died != null)
                    Died(this, new DiedEventArgs(this));
            }
        }

        protected override string SpriteFile { get { return "unit.bmp"; } }
        protected override int AnimationDelay { get { return 15; } }
        protected override int[] FramesPerDirection { get { return new int[] { 20 }; } }
        [DescriptorProperty]
        public override float Speed { get { return 2f; } }
        public override string Description { get { return @"base of all enemies - low health points and speed"; } }

        protected new static List<Animation.Animation> animations;

        [DescriptorProperty]
        public override double Rating
        {
            get { return Speed * HitPoints * Damage * (Strategy == MazeStrategy.Air ? 1.2 : 1); }
        }

        #region sound

        protected static Sound SpawnSound;
        protected virtual string SpawnSoundFile { get { return "Humm.wav"; } }

        protected static Sound DieSound;
        protected virtual string DieSoundFile { get { return "explos.wav"; } }

        protected static Sound ThroughSound;
        protected virtual string ThroughSoundFile { get { return "laugh.wav"; } }

        #endregion
    }
}
