﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace TowerDefence
{
    public class ObjectDialog<T> : Form where T : BaseObject
    {
        public TypeDescriptor SelectedObject
        {
            get { return objectListBox.SelectedObject; }
        }

        protected ObjectListBox objectListBox;

        public ObjectDialog()
        {
            if (typeof(T) == typeof(TowerBase))
                objectListBox = new TowerListBox();
            else if (typeof(T) == typeof(ShotBase))
                objectListBox = new ShotListBox();
            else if (typeof(T) == typeof(UnitBase))
                objectListBox = new UnitListBox();
            else
                throw new Exception(typeof(T).FullName + " is not a valid generic type argument for ObjectDialog<T>!");

            this.Controls.Add(objectListBox);
            objectListBox.Dock = DockStyle.Fill;
            objectListBox.Initialize();

            this.Text = typeof(T).Name + "Dialog";
        }
    }

    public class TowerDialog : ObjectDialog<TowerBase>
    {
        public TowerTypeDescriptor SelectedTower
        {
            get { return (objectListBox as TowerListBox).SelectedTower; }
        }
    }

    public class ShotDialog : ObjectDialog<ShotBase>
    {
        public ShotTypeDescriptor SelectedShot
        {
            get { return (objectListBox as ShotListBox).SelectedShot; }
        }
    }

    public class UnitDialog : ObjectDialog<UnitBase>
    {
        public UnitTypeDescriptor SelectedUnit
        {
            get { return (objectListBox as UnitListBox).SelectedUnit; }
        }
    }
}
