﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SdlDotNet.Core;
using System.Collections;

namespace TowerDefence
{
    class Wave
    {
        static public Wave Empty = new Wave();

        List<Tuple<int, UnitBase>> units;

        int startTime;//to determine time to spawn units

        public decimal PrizeMoney { get; set; }

        public class WaveCompletedEventArgs : EventArgs
        {
            public decimal PrizeMoney { get; private set; }
            public WaveCompletedEventArgs(Wave wave)
            {
                PrizeMoney = wave.PrizeMoney;
            }
        }

        public event EventHandler<WaveCompletedEventArgs> WaveCompleted;

        public class UnitSpawnedEventArgs : EventArgs
        {
            public int Count { get; private set; }
            public UnitSpawnedEventArgs(Wave wave)
            {
                Count = wave.Count;
            }
        }

        public event EventHandler<UnitSpawnedEventArgs> UnitSpawned;

        public int Count { get { return units.Count; } }

        public bool Dead { get; private set; }

        public Wave()
        {
            Dead = false;
            startTime = int.MinValue;
            PrizeMoney = 10M;
            units = new List<Tuple<int, UnitBase>>();
        }

        /// <summary>
        /// Adds unit to wave
        /// </summary>
        /// <param name="unit">unit to add</param>
        /// <param name="time">time to add unit in seconds</param>
        public void Add(UnitBase unit, float time)
        {
            lock (units)
            {
                units.Add(new Tuple<int, UnitBase>((int)(time * 1000), unit));
            }
        }

        public IEnumerable<UnitBase> Update(TickEventArgs args)
        {
            if (!Dead)
            {
                if (startTime == int.MinValue)
                    startTime = args.LastTick;

                Tuple<int, UnitBase>[] unitsToSpawn = null;
                lock (units)
                {
                    unitsToSpawn = units.Where(tiu => tiu.Item1 < args.LastTick - startTime).ToArray();
                    foreach (var item in unitsToSpawn)
                        units.Remove(item);

                    if (units.FirstOrDefault() == null && startTime != args.LastTick)
                    {
                        Dead = true;
                        if (WaveCompleted != null)
                            WaveCompleted(this, new WaveCompletedEventArgs(this));
                    }
                }

                if (unitsToSpawn.FirstOrDefault() != null && UnitSpawned != null)
                    UnitSpawned(this, new UnitSpawnedEventArgs(this));

                return unitsToSpawn.Select(tiu => tiu.Item2);
            }
            else
                return new List<UnitBase>();
        }
    }
}
