﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Drawing.Imaging;

namespace Animation
{
    public class Animation
    {
        public string Name { get; private set; }
        public List<Bitmap> Frames { get; private set; }
        public TimeSpan Period { get; private set; }
        public int Length;

        public Bitmap this[int i]
        {
            get
            {
                return Frames[i];
            }
        }

        public Animation(string name, TimeSpan period, List<Bitmap> frames)
        {
            Name = name;
            Period = period;
            Frames = frames;
            Length = Frames.Count;
        }

        static public Animation AnimationFromFile(TimeSpan period, string fileName, int frames, string nameOfAnimation, Color transparentColor)
        {
            Bitmap imgAll = new Bitmap(fileName);
            imgAll.MakeTransparent(transparentColor);

            int width = imgAll.Width / frames;

            int offset = 0;
            List<Bitmap> blist = new List<Bitmap>();
            for (int i = 0; i < frames; i++)
            {
                blist.Add(imgAll.Clone(new Rectangle(offset, 0, width, imgAll.Height), imgAll.PixelFormat));
                offset += width;
            }

            return new Animation(nameOfAnimation, period, blist);
        }

        static public List<Animation> MultipleAnimationsFromFile(TimeSpan period, string fileName, int[] framesPerAnimation, string[] namesOfAnimations, Color transparentColor)
        {
            if(framesPerAnimation.Length != namesOfAnimations.Length)
                throw new Exception("framesPerAnimation.Length has to equal namesOfAnimations.Length");

            Bitmap imgAll = new Bitmap(fileName);
            imgAll.MakeTransparent(transparentColor);

            int width = imgAll.Width / framesPerAnimation.Sum();

            int offset = 0;
            var list = new List<Animation>();
            for (int j = 0; j < 4; j++)
            {
                List<Bitmap> blist = new List<Bitmap>();
                for (int i = 0; i < framesPerAnimation[j]; i++)
                {
                    blist.Add(imgAll.Clone(new Rectangle(offset, 0, width, imgAll.Height), imgAll.PixelFormat));
                    offset += width;
                }
                list.Add(new Animation(namesOfAnimations[j], period, blist));
            }

            return list;
        }
    }
}
