﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Threading;
using System.Diagnostics;

namespace TowerDefence
{
    /// <summary>
    /// main window
    /// </summary>
    public partial class Form1 : Form
    {
        GameLogic gameLogic;

        Settings settings;

        public Form1()
        {
            InitializeComponent();
            towerListBox1.Initialize();
            towerListBox1.Enabled = false;
            button3.Enabled = false;
            this.FormClosing += new FormClosingEventHandler(Form1_FormClosing);
            gameLogic = new GameLogic(pictureBox1.Width, pictureBox1.Height);
            gameLogic.Refreshed += new EventHandler<RefreshedEventArgs>(gameLogic_Refreshed);
            gameLogic.WaveDefeated += new EventHandler<GameLogic.WaveDefeatedEventArgs>(gameLogic_WaveDefeated);
            gameLogic.NewWave += new EventHandler<GameLogic.WaveEventArgs>(gameLogic_NewWave);
            gameLogic.PlayerMoneyChanged += new EventHandler<Player.StateChangedEventArgs>(gameLogic_PlayerMoneyChanged);
            gameLogic.PlayerHealthChanged += new EventHandler<Player.StateChangedEventArgs>(gameLogic_PlayerHealthChanged);
            gameLogic.UnitSpawned += new EventHandler<Wave.UnitSpawnedEventArgs>(gameLogic_UnitSpawned);
            gameLogic.PlayerDefeated += new EventHandler<Player.StateChangedEventArgs>(gameLogic_PlayerDefeated);
            gameLogic.TowerNumberChanged += new EventHandler<GameLogic.TowerNumberChangedEventArgs>(gameLogic_TowerNumberChanged);
            settings = new Settings();
            settings.PlayerName = gameLogic.Player.Name;
            settings.NameChanged += new EventHandler<Settings.NameChangedEventArgs>(settings_NameChanged);
            settings.SoundSettingsChanged += new EventHandler<Settings.SoundSettingsChangedEventArgs>(settings_SoundSettingsChanged);
        }

        void gameLogic_TowerNumberChanged(object sender, GameLogic.TowerNumberChangedEventArgs e)
        {
            var numbers = label7.Text.Split('/').Select(p => int.Parse(p)).ToList();
            if (e.NumberOfTowers.HasValue)
                numbers[0] = e.NumberOfTowers.Value;
            if (e.MaximumNumberOfTowers.HasValue)
                numbers[1] = e.MaximumNumberOfTowers.Value;
            label7.Text = numbers[0].ToString() + '/' + numbers[1];
        }

        void settings_SoundSettingsChanged(object sender, Settings.SoundSettingsChangedEventArgs e)
        {
            gameLogic.SetSoundSettings(e);
        }

        void gameLogic_PlayerDefeated(object sender, Player.StateChangedEventArgs e)
        {
            this.Invoke(new Action(() =>
            {
                finishToolStripMenuItem.Enabled = false;
                button1.Enabled = false;
                button2.Enabled = false;
                button3.Enabled = false;
                MessageBox.Show("Lost");
            }));
        }

        void settings_NameChanged(object sender, Settings.NameChangedEventArgs e)
        {
            groupBox1.Text = settings.PlayerName;
            gameLogic.PlayerName = settings.PlayerName;
        }

        void gameLogic_UnitSpawned(object sender, Wave.UnitSpawnedEventArgs e)
        {
            this.Invoke(new Action(() => label10.Text = e.Count.ToString()));
        }

        void gameLogic_PlayerHealthChanged(object sender, Player.StateChangedEventArgs e)
        {
            this.Invoke(new Action(() => label3.Text = e.Player.HitPoints.ToString()));
        }

        void gameLogic_WaveDefeated(object sender, GameLogic.WaveDefeatedEventArgs e)
        {
            this.Invoke(new Action(() => button3.Enabled = true));
        }

        void gameLogic_PlayerMoneyChanged(object sender, Player.StateChangedEventArgs e)
        {
            this.Invoke(new Action(() =>
            {
                label4.Text = e.Player.Money.ToString();
                button1.Enabled = e.Player.Money >= gameLogic.MediPackCost;
                button2.Enabled = e.Player.Money >= gameLogic.TowerBuildRightCost;
            }));
        }

        void gameLogic_NewWave(object sender, GameLogic.WaveEventArgs e)
        {
            label10.Text = e.NewWave.Count.ToString();
            label9.Text = e.NewWave.PrizeMoney.ToString();
            label5.Text = (int.Parse(label5.Text) + 1).ToString();
        }

        void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            gameLogic.Finish();
        }

        void gameLogic_Refreshed(object sender, RefreshedEventArgs e)
        {
            pictureBox1.Image = e.Screen;
            pictureBox1.Refresh();
        }

        private void pictureBox1_MouseClick(object sender, MouseEventArgs e)
        {
            if (e.Button == System.Windows.Forms.MouseButtons.Left)
                gameLogic.BuildTower(e.Location, towerListBox1.SelectedTower);
            if (e.Button == System.Windows.Forms.MouseButtons.Right)
                gameLogic.RemoveTower(e.Location);
        }

        private void startToolStripMenuItem_Click(object sender, EventArgs e)
        {
            startToolStripMenuItem.Enabled = false;
            finishToolStripMenuItem.Enabled = true;

            gameLogic.Start();

            groupBox1.Text = gameLogic.Player.Name;
            label3.Text = gameLogic.Player.HitPoints.ToString();
            label4.Text = gameLogic.Player.Money.ToString();

            button3.Enabled = true;
            towerListBox1.Enabled = true;
        }

        private void finishToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void button3_Click(object sender, EventArgs e)
        {
            gameLogic.Wave();
            button3.Enabled = false;
        }

        private void enemiesToolStripMenuItem_Click(object sender, EventArgs e)
        {
            new UnitDialog().Show();
        }

        private void ammunitionToolStripMenuItem_Click(object sender, EventArgs e)
        {
            new ShotDialog().Show();
        }

        private void towersToolStripMenuItem_Click(object sender, EventArgs e)
        {
            new TowerDialog().Show();
        }

        private void networkToolStripMenuItem_Click(object sender, EventArgs e)
        {
            settings.ShowDialog();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            gameLogic.BuyMediPack();
        }

        private void button2_Click(object sender, EventArgs e)
        {
            gameLogic.BuyTowerBuildRight();
        }

        private void gameToolStripMenuItem1_Click(object sender, EventArgs e)
        {
            new TowerDefence.Forms.Manual().Show();
        }
    }
}
