var playPath = function(width, height) {
    var $g = $('#game');
	var size = new Size(width, height);
    var maze = new Maze(size);

    output(maze);

    $('.block').click(function() {
    	var x = $(this).data('x');
    	var y = $(this).data('y');

    	if($(this).hasClass('full')) {
    		if(maze.tryRemove(new Point(x, y)))
    			$(this).removeClass('full').addClass('empty');
    	} else {
    		if(maze.tryBuild(new Point(x, y)))
    			$(this).removeClass('empty').addClass('full');
    	}

    	$('.wayItem').remove();
    	var pts = maze.getPath(MazeStrategy.Manhatten);
	    showPath(false, pts, 'wayItem');
    });

	var pts = maze.getPath(MazeStrategy.Manhatten);
    showPath(false, pts, 'wayItem');
};

var printPath = function() {
    var size = new Size(16, 16);
    var maze = new Maze(size);

    for(var i = 3; i < 12; i++)
    	maze.tryBuild(new Point(5, i));

    for(var i = 6; i < 16; i++)
    	maze.tryBuild(new Point(7, i));

    for(var i = 2; i < 13; i++)
    	maze.tryBuild(new Point(9, i));

    output(maze);

    var ptsOriginal = maze.getPath(MazeStrategy.Manhattan);
    showPath(false, ptsOriginal, 'originalItem');

    var ptsCompare = maze.getPath(MazeStrategy.Euclidean);
    showPath(true, ptsCompare, 'wayItem');
};

var output = function(maze) {
    var $g = $('#game');
	var size = maze.gridDim;

	for(var i = 0; i < size.Height; i++) {
    	var $d = $('<div />').addClass('row');

    	for(var j = 0; j < size.Width; j++) {
    		$d.append($('<div />').addClass('block').addClass(maze.grid[j][i] ? 'empty' : 'full').data('x', j).data('y', i));
    	}

    	$g.append($d);
    }
};

var drawPoint = function(point, cls) {
		var row = $('.row').eq(point.Y);
		var block = $('.block', row).eq(point.X);
		block.append($('<div />').addClass(cls));
};

var showPath = function(animate, pts, cls, index) {
	var i = index || 0;
	var c = cls || 'wayItem';

	if(animate) {
		setTimeout(function() {
			drawPoint(pts[i], c);

			if(i + 1 < pts.length)
				showPath(animate, pts, c, i  + 1);
		}, 500);

		return;
	}

	for(; i < pts.length; i++)
		drawPoint(pts[i], c);
};

$(document).ready(function() {
	//printPath();
	playPath(30, 21);
});