var x, y, vx, vy, m, r, nop, dt=0.03,ex, interval=false, rememberVx=null, rememberVy=null;

self.addEventListener('message', function (event) {
	if (event.data==='stop'){
		rememberVx=vx;
		rememberVy=vy;
		clearInterval(interval);}
	else{	
			
			x=JSON.parse(event.data).X;
			y=JSON.parse(event.data).Y;
			vx=JSON.parse(event.data).Vx;
			vy=JSON.parse(event.data).Vy;
			m=JSON.parse(event.data).M;
			r=JSON.parse(event.data).R;
			ex=JSON.parse(event.data).Ex;
			nop=m.length;
			if (rememberVy){
				for (var i=rememberVy.length; i--;){
					vx[i]=rememberVx[i];
					vy[i]=rememberVy[i];
				}
			}
			interval=setInterval(run, 50);

	}
	
}, false);

function run(){
	var it=700;

	while	(it){
		--it;
		for (var i=nop; i--;){
			var	aTotX=0,
				aTotY=0;
			for (var j=nop; j--;){
				if (i===j) continue;
				var tmp=new a(x[i],y[i],x[j],y[j],j);
				aTotX+=tmp.X;
				aTotY+=tmp.Y;
			}
			
			vx[i]+=aTotX*dt;
			vy[i]+=aTotY*dt;
			x[i]+=vx[i]*dt;
			y[i]+=vy[i]*dt;
		}
	}
	
	var out={};
	out.X=x;
	out.Y=y;
	self.postMessage(JSON.stringify(out));
}


function a(x1,y1,x2,y2,i){
  var deltaX=(x2-x1), deltaY=(y2-y1), abstand=Math.sqrt(deltaX*deltaX+deltaY*deltaY),
    erg=0.0001 * m[i]*Math.exp(ex*Math.log(abstand));
  if(abstand>0){
    this.X=erg*deltaX/abstand;
    this.Y=erg*deltaY/abstand;
  }
  else{
    this.X=0;
    this.Y=0;
  } 
}

