$(document).ready(function (){
var canvas=document.getElementById('canvas'),
    c=canvas.getContext('2d'),
    cwidth,
    cheight,
    m=[],
    x=[],
    y=[],
    vx=[],
    vy=[],
    r=[],
    ex=-2,
    dt=0.03,
    nop,
    workerYN=!!(typeof Worker);
canvas.height=window.screen.height*3/4;
canvas.width=window.screen.height*3/4;
cwidth=canvas.width;
cheight=canvas.height;
changeCss('canvas', 'border-radius', cwidth/2);

  c.translate(cwidth/2,cheight/2);
  c.scale(1,-1);


add(cwidth/4,0,0,0.06,2,2);
add(3*cwidth/8,0,0,0.05,3,3);
add(0,0,0,0,10000,7);




$('#plus').click(function(){
	add((Math.random()-0.5)*cwidth*0.8, (Math.random()-0.5)*cheight*0.8, (Math.random()-0.5)/10, (Math.random()-0.5)/10, Math.random()*100, Math.random()*5);
})

$('#minus').click(function(){
	$('.bodyBox:eq(0)').remove();
})

function add(x,y,vx,vy,m,r){
	$('<div></div>')
		.attr({'class':'star bodyBox'})
		.html('<ul><li>(x,y) <input title="set position" type=number class="in bodyX" min=-400 max=400 value='+x+'><input title="set position" type=number class="in bodyY" min=-400 max=400 value='+y+'></li><li>(v<span class="lower">x</span>,v<span class="lower">y</span>) <input title="set velocity in x-direction" type=number step="0.01" class="in bodyVx"  min=-1 max=1 value='+vx+'><input title="set velocity in y-direction" type=number step="0.01" class="in bodyVy"  min=-1 max=1 value='+vy+'></li><li> M, r <input title="set the mass" type=number class="in bodyM" value='+m+' ><input title="set the radius" type=number step="0.5" class="in bodyR" value='+r+'></li></ul>')
		.prependTo('#controlls');
}


if (workerYN) {
        var  w=new Worker('rechensklave3.js');

        $('#startStop').click(function(){ 
          var a=$('#startStop').val();
          if (a==='start') {
            einlesen();
            nop=x.length;
            $('#startStop').val('stop');
            var out={};
            out.X=x; out.Y=y; out.Vx=vx; out.Vy=vy; out.R=r; out.M=m; out.Ex=ex; out.S='start';
            w.postMessage(JSON.stringify(out));
            
          }
          else {
            $('#startStop').val('start'); 
            w.postMessage('stop');
          }
        });


        w.addEventListener('message', function(event) {
        		console.log(event.data);
        		x=JSON.parse(event.data).X;
        		y=JSON.parse(event.data).Y;
        		draw();
        		},false);
}

else {
          $('#startStop').click(function(){ 
            var a=$('#startStop').val();
            if (a==='start') {
              einlesen();
              nop=x.length;
              $('#startStop').val('stop');
              interval = setInterval(run,50);
              
            }
            else {
              $('#startStop').val('start'); 
              clearInterval(interval);
            }
          });
}

function einlesen() {
	$('.bodyBox').each(function(i,v) {
			x.push($('.bodyX', this).val() * 1);
			y.push($('.bodyY', this).val() * 1);
			vx.push($('.bodyVx', this).val() * 1);
			vy.push($('.bodyVy', this).val() * 1);
			m.push($('.bodyM', this).val() * 1);
			r.push($('.bodyR', this).val()*1);
			ex=$('#ex').val();
      nop=x.length;
	});
}

function run(){
  var it=700;

  while (it){
    --it;
    for (var i=nop; i--;){
      var aTotX=0,
        aTotY=0;
      for (var j=nop; j--;){
        if (i===j) continue;
        var tmp=new a(x[i],y[i],x[j],y[j],j);
        aTotX+=tmp.X;
        aTotY+=tmp.Y;
      }
      
      vx[i]+=aTotX*dt;
      vy[i]+=aTotY*dt;
      x[i]+=vx[i]*dt;
      y[i]+=vy[i]*dt;
    }
  }
  
  draw();
}

function a(x1,y1,x2,y2,i){
  var deltaX=(x2-x1), deltaY=(y2-y1), abstand=Math.sqrt(deltaX*deltaX+deltaY*deltaY),
    erg=0.0001 * m[i]*Math.exp(ex*Math.log(abstand));
  if(abstand>0){
    this.X=erg*deltaX/abstand;
    this.Y=erg*deltaY/abstand;
  }
  else{
    this.X=0;
    this.Y=0;
  } 
}



function circle(x,y,r){
  c.beginPath();
  c.arc(x,y,r,0,Math.PI*2,true);
  c.shadowColor='#fff';
   c.shadowBlur=50;
   c.shadowOffSetX=0;
   c.shadowOffSetY=0;
   c.fillStyle='#ffa'
  
  c.fill();
  }

function draw(){
  c.clearRect(-cwidth/2,-cheight/2,cwidth,cheight);

  for(var i=nop; i--;) {
    circle(x[i],y[i],r[i]);
    }
}


});


function changeCss(selector, property, value) {
    for (var i=0; i<document.styleSheets.length;i++) {//Loop through all styles
        //Try add rule
        try { document.styleSheets[i].insertRule(selector+ ' {'+property+':'+value+'}', document.styleSheets[i].cssRules.length);
        } catch(err) {try { document.styleSheets[i].addRule(selector, property+':'+value);} catch(err) {}}//IE
    }
}