var keyboardP1 = {
		left: false,
		right: false,
		up: false,
		down: false,
		lowKick: false,
		lowPunch: false,
		highPunch: false,
		upperCut: false,
		listenerPress: function(ev) {
			keyboardP1.handler(ev, true);
		},
		listenerUnpress: function(ev) {
			keyboardP1.handler(ev, false);
		},
		bind: function() {
			if(!keyboardP1.bound) {
				document.addEventListener('keydown', keyboardP1.listenerPress, false);
				document.addEventListener('keyup', keyboardP1.listenerUnpress, false);
				keyboardP1.bound = true;
			}
		},
		unbind: function() {
			document.removeEventListener('keydown', keyboardP1.listenerPress);
			document.removeEventListener('keyup', keyboardP1.listenerUnpress);
			resetKeyboard(keyboardP1);
			keyboardP1.bound = false;
		},
		handler: function(event, pressed) {
			switch (event.keyCode) {
				case 37:
					keyboardP1.left = pressed;
					break;
				case 38:
					keyboardP1.up = pressed;
					break;
				case 39:
					keyboardP1.right = pressed;
					break;
				case 40:
					keyboardP1.down = pressed;
					break;
				case 101:
					keyboardP1.lowKick = pressed;
					break;
				case 100:
					keyboardP1.lowPunch = pressed;
					break;
				case 103:
					keyboardP1.highPunch = pressed;
					break;
				case 104:
					keyboardP1.upperCut = pressed;
					break;
				default:
					return false;
			}
			
			event.preventDefault();
			return true;
		},
		isTopLeft: function() {
			return keyboardP1.left && keyboardP1.up;
		},
		isTopRight : function() {
			return keyboardP1.right && keyboardP1.up;
		},
		bound: false
};

var keyboardP2 = {
		left: false,
		right: false,
		up: false,
		down: false,
		lowKick: false,
		lowPunch: false,
		highPunch: false,
		upperCut: false,
		listenerPress: function(ev) {
			keyboardP2.handler(ev, true);
		},
		listenerUnpress: function(ev) {
			keyboardP2.handler(ev, false);
		},
		bind: function() {
			if(!keyboardP2.bound) {
				document.addEventListener('keydown', keyboardP2.listenerPress, false);
				document.addEventListener('keyup', keyboardP2.listenerUnpress, false);
				keyboardP2.bound = true;
			}
		},
		unbind: function() {
			document.removeEventListener('keydown', keyboardP2.listenerPress);
			document.removeEventListener('keyup', keyboardP2.listenerUnpress);
			resetKeyboard(keyboardP2);
			keyboardP2.bound = false;
		},
		handler: function(event, pressed) {
			switch (event.keyCode) {
				case 65:
					keyboardP2.left = pressed;
					break;
				case 87:
					keyboardP2.up = pressed;
					break;
				case 68:
					keyboardP2.right = pressed;
					break;
				case 83:
					keyboardP2.down = pressed;
					break;
				case 74:
					keyboardP2.lowKick = pressed;
					break;
				case 72:
					keyboardP2.lowPunch = pressed;
					break;
				case 90:
					keyboardP2.highPunch = pressed;
					break;
				case 85:
					keyboardP2.upperCut = pressed;
					break;
				default:
					return false;
			}
			
			event.preventDefault();
			return true;
		},
		isTopLeft: function() {
			return keyboardP2.left && keyboardP2.up;
		},
		isTopRight : function() {
			return keyboardP2.right && keyboardP2.up;
		},
		bound: false
};

function bindKeyboards() {
	keyboardP1.bind();
	keyboardP2.bind();
}

function unBindKeyboards() {
	keyboardP1.unbind();
	keyboardP2.unbind();
}

function resetKeyboard(keyboard) {
	keyboard.left = false;
	keyboard.up = false;
	keyboard.right = false;
	keyboard.down = false;
	keyboard.lowKick = false;
	keyboard.lowPunch = false;
	keyboard.highPunch = false;
	keyboard.upperCut = false;
}