//Audio
var audioElement;
var singleAudioElem;
var gameFinished;

var roundtime = 120;

var gameReady = false;

var counter = 0;

var gameStateEnum = {
	draw : 0,
	player1Wins : 1,
	player2Wins : 2,
	menuActive : 3,
	gameActive : 4
};
var gameState;

var MenuMove = {
	None : 0,
	Left1 : 37,
	Up1 : 38,
	Right1 : 39,
	Down1 : 40,
	Left2 : 65,
	Up2 : 87,
	Right2 : 68,
	Down2 : 83
};

// Character Definitions

var line1 = [ "Ryu", "Honda", "Blanka", "Guile" ];
var line2 = [ "Ken", "ChunLi", "Zangief", "Dhalsim" ];
var charArray = [ line1, line2 ];

// --------- Menu Directions --------
var MenuPlayer1 = {
	id : 1,
	div : ".menuPlayer1",
	posHoriz : 0,
	posVert : 0
};

var MenuPlayer2 = {
	id : 2,
	div : '.menuPlayer2',
	posHoriz : 0,
	posVert : 0
};

var moveHoriz = 'margin-left';
var moveVert = 'margin-top';

var blockSizeHoriz = 80;
var blockSizeVert = 58;

// ------END Menu Directions

$(document).ready(function() {
	startMenu();
	// startEndGameScreen();
});

// ----------------------- Menu Functions ----------------------
function startMenu() {
	if (gameState == gameStateEnum.menuActive) {
		return;
	}
	
	playerOne.menuChose = false;
	playerTwo.menuChose = false;
	
	$('#playerDescr1').removeClass('menuPlayerChosen');
	$('#menuPlayer1').removeClass('menuPlayerChosen');
	$('#playerDescr2').removeClass('menuPlayerChosen');
	$('#menuPlayer2').removeClass('menuPlayerChosen');
	
	$('#gameScreen').css("display", "none");
	$('#endGameScreen').css("display", "none");
	$('#menuScreen').css("display", "block");
	
	//--sound
	if (singleAudioElem!= null)
	if (singleAudioElem.id === "game" ){
		if(singleAudioElem.play) {
			singleAudioElem.loop = false; 
			singleAudioElem.pause(); 
		}
	} startSoundLoop("menu");
	
	document.addEventListener('keydown', menuKeyPress, false);
	// document.addEventListener('keyup', menuKeyPress, false);
	
	$('#gameWinner').css("display", "none");
	
	document.addEventListener('keydown', menuKeyPress, false);
	gameState = gameStateEnum.menuActive;
}

/**
 * Starts a new Fight!
 */
function startGame() {
	createWinIcons();

	//--sound
	stopSound("menu");
	singleAudioElem = document.getElementById("game");
	if(singleAudioElem.paused) {
		singleAudioElem.play();
		singleAudioElem.loop = true; 
		}
		
	if (playerOne.wins === 0 || playerTwo.wins === 0) {		
	updateSource("AlexBritt/roundOneFight.ogg");
	startSound("empty");
	}

	playerOne.name = charArray[MenuPlayer1.posVert][MenuPlayer1.posHoriz];
	playerTwo.name = charArray[MenuPlayer2.posVert][MenuPlayer2.posHoriz];

	$('#gameScreen').css("display", "block");
	$('#endGameScreen').css("display", "none");
	$('#menuScreen').css("display", "none");
	$('#gameWinner').css("display", "none");
	
	document.removeEventListener('keydown', menuKeyPress);
	
	initGame();

	gameState = gameStateEnum.gameActive;
}

function startEndGameScreen() {
	$('#gameScreen').css("display", "none");
	$('#endGameScreen').css("display", "block");
	$('#menuScreen').css("display", "none");
	$('#gameWinner').css("display", "none");

	updateSource("AlexBritt/"+getRandom(1, 4)+".ogg");
	startSound("empty");

	if(playerOne.wins > 1) {
		if(Player1 == ryuSprites) {
			$('#containerPlayer1').css("background", "url(img/ryuWin.png)");
		} else {
			$('#containerPlayer1').css("background", "url(img/chunliWin.png)");
		}
		
		if(Player2 == ryuSprites) {
			$('#containerPlayer2').css("background", "url(img/ryuLose.png)");
		} else {
			$('#containerPlayer2').css("background", "url(img/chunliLose.png)");
		}
		
	} else {
		if(Player1 == ryuSprites) {
			$('#containerPlayer2').css("background", "url(img/ryuWin.png)");
		} else {
			$('#containerPlayer2').css("background", "url(img/chunliWin.png)");
		}
		
		if(Player2 == ryuSprites) {
			$('#containerPlayer1').css("background", "url(img/ryuLose.png)");
		} else {
			$('#containerPlayer1').css("background", "url(img/chunliLose.png)");
		}
	}
}

/**
 * Resets alls fight values after a fight
 */
function resetValues() {
	
	if (playerOne.wins === 1|| playerTwo.wins === 1) {
		updateSource("AlexBritt/"+getRandom(5, 8)+".ogg");
		startSound("empty");
		}
	
	resetToStart();
	playerOne.life = 0;
	playerTwo.life = 0;
	playerOne.menuChosen = false;
	playerTwo.menuChosen = false;
	roundtime = 120;

	createWinIcons();

	gameState = gameStateEnum.gameActive;
	$('#gameWinner').text("");
	updatePlayerLife();
}

/**
 * Creates the icons that display how often a player has won
 */
function createWinIcons() {

	if (playerOne.wins === 0) {
		$('#p1Win1').css("display", "none");
		$('#p1Win2').css("display", "none");
	}
	if (playerTwo.wins === 0) {
		$('#p2Win1').css("display", "none");
		$('#p2Win2').css("display", "none");
	}

	if (playerOne.wins === 1) {
		$('#p1Win1').css("display", "block");
		$('#p1Win2').css("display", "none");
	}
	if (playerOne.wins === 2) {
		$('#p1Win1').css("display", "block");
		$('#p1Win2').css("display", "block");
	}

	if (playerTwo.wins === 1) {
		$('#p2Win1').css("display", "block");
		$('#p2Win2').css("display", "none");
	}
	if (playerTwo.wins === 2) {
		$('#p2Win1').css("display", "block");
		$('#p2Win2').css("display", "block");
	}

}

//----------------- Player Hits --------------------

//awaits hitting player and his hit strength
function playerHit(player, strength) {

	if (player === Figures.ryuSprite) {
		updateSource("Hitsound/"+getRandom(1, 8)+".ogg");
		startSound("empty");
		playerTwo.life -= strength;
	} else {
		updateSource("Hitsound/"+getRandom(9, 16)+".ogg");
		startSound("empty");
		playerOne.life -= strength;
	}

	if (playerOne.life < 1 || playerTwo.life < 1) {
		endGame();
		return;
	}
}

//-------------- Starting Screen -----------------

function gameCountdown() {
	

	var life = playerOne.life;

	if(life > 100) {
		playerOne.life = 100;
		life = 100;
	}

	if(life === 1) {
		$('#timebar').text("3");
	} else if(life === 33) {
		$('#timebar').text("2");
	} else if(life === 66) {
		$('#timebar').text("1");
	} else if(life === 100) {
		$('#timebar').text("");
		$('#gameWinner').text("GO!");
		hideGoTimer();
		$('#gameWinner').css("display", "block");
		startClock();
		gameReady = true;
		updatePlayerLife();

		return;
	}
	
	playerOne.life++;
	playerTwo.life++;
	
	setTimeout('gameCountdown()', 30);
	updatePlayerLife();

}

var goTimer = 3;
function hideGoTimer() {

	goTimer--;

	if (goTimer === 0) {
		goTimer = 3;
		$('#gameWinner').text("");
		return;
	}

	setTimeout('hideGoTimer()', 1000);

}

//---------------- Combat Clock -------------------

function startClock() {

	if (gameState != gameStateEnum.gameActive) {
		return;
	}

	$('#timebar').text(roundtime);

	roundtime--;

	if (roundtime <= -1) {
		endGame();
		return;
	} else {
		setTimeout('startClock()', 1000);
		updatePlayerLife();
	}


}

//--------------------- Livebar status ---------------------------

function updatePlayerLife() {
	// ---------------- Lifebar Player1 ----------------------
	var life1 = 100 - playerOne.life;

	if (life1 < 50) {
		$('#leftbar').css(
				'background-image',
				'-webkit-gradient(linear,left bottom,right bottom,color-stop('
						+ life1 / 50 + ', rgb(240,240,26)),color-stop(' + 0.01
						+ ', rgb(247,10,10)))');
	} else if (life1 < 100) {
		$('#leftbar').css(
				'background-image',
				'-webkit-gradient(linear,left bottom,right bottom,color-stop('
						+ 1.00 + ', rgb(240,240,26)),color-stop('
						+ (life1 - 50) / 50 + ', rgb(247,10,10)))');
	}
	if (life1 === 0) {
		$('#leftbar').css('background', 'yellow');
	}
	if (life1 >= 100) {
		$('#leftbar').css('background', 'red');
	}

	// ---------------- Lifebar Player2 ----------------------
	var life2 = playerTwo.life;
	if (life2 < 50) {
		$('#rightbar').css(
				'background-image',
				'-webkit-gradient(linear,left bottom,right bottom,color-stop('
						+ life2 / 50 + ', rgb(247,10,10)),color-stop(' + 0.01
						+ ', rgb(240,240,26)))');
	} else if (life2 < 100) {
		$('#rightbar').css(
				'background-image',
				'-webkit-gradient(linear,left bottom,right bottom,color-stop('
						+ 1.00 + ', rgb(247,10,10)),color-stop(' + (life2 - 50)
						/ 50 + ', rgb(240,240,26)))');
	}

	if (life2 <= 0) {
		$('#rightbar').css('background', 'red');
	}
	if (life2 === 100) {
		$('#rightbar').css('background', 'yellow');
	}

}

//--------------------- End Game -------------------------------

/**
 * This function is called when a player has won at least 2 out of 3 games
 */
function endGame() {
	
	unBindKeyboards();
	
	//slow the gui
	initMainLoop(1000);
	
	$('#gameWinner').css("display", "block");
	$('#timebar').text("END");
	
	
	if (playerOne.life > playerTwo.life) {
		gameState = gameStateEnum.player1Wins;
		$('#gameWinner').text("Player1 Wins");
		playerOne.wins++;
		playerOneWinAnimation();//zeig animation das spieler 1 gewonnen hat
	} else if(playerOne.life < playerTwo.life){
		gameState = gameStateEnum.player2Wins;
		$('#gameWinner').text("Player2 Wins");
		playerTwo.wins++;
		playerTwoWinAnimation(); //zeig animation das spieler 2 gewonnen hat
	} else {
		$('#gameWinner').text("Draw");
		playerTwo.wins++;
		playerOne.wins++;
	}
	displayWinner();
}

var winningTimeout = 3;
function displayWinner() {

	
	createWinIcons();
	winningTimeout--;

	if (winningTimeout === 0) {
		winningTimeout = 3;

		if (playerOne.wins > 1) {

			startEndGameScreen();
			displayEndGame();

		} else if (playerTwo.wins > 1) {
			
			startEndGameScreen();
			displayEndGame();
		
		} else {
			initGame();
			
			winningTimeout = 3;
		}
		
	} else {
		
		setTimeout('displayWinner()', 1000);
	}

}



var endgameTimeout = 3;

/**
 * Display the menu after the end of a game
 */
function displayEndGame() {
	endgameTimeout--;

	if (endgameTimeout === 0) {
		// -- reset values
		playerOne.wins = 0;
		playerTwo.wins = 0;
		endgameTimeout = 3;
		resetValues();
		startMenu();
		
	} else {
		setTimeout('displayEndGame()', 1000);
	}
}


// ----------------- Menu Actions -----------------

var menuKeyPress = function(event) {

	switch (event.keyCode) {
	case MenuMove.Left1:
		moveMenuPlayer(MenuPlayer1, -blockSizeHoriz, moveHoriz,
				MenuPlayer1.posHoriz === 0 ? false : Directions.Left);
		break;
	case MenuMove.Up1:
		moveMenuPlayer(MenuPlayer1, -blockSizeVert, moveVert,
				MenuPlayer1.posVert === 0 ? false : Directions.Top);
		break;
	case MenuMove.Right1:
		moveMenuPlayer(MenuPlayer1, blockSizeHoriz, moveHoriz,
				MenuPlayer1.posHoriz === 3 ? false : Directions.Right);
		break;
	case MenuMove.Down1:
		moveMenuPlayer(MenuPlayer1, blockSizeVert, moveVert,
				MenuPlayer1.posVert === 1 ? false : Directions.Bottom);
		break;
	case MenuMove.Left2:
		moveMenuPlayer(MenuPlayer2, -blockSizeHoriz, moveHoriz,
				MenuPlayer2.posHoriz === 0 ? false : Directions.Left);
		break;
	case MenuMove.Up2:
		moveMenuPlayer(MenuPlayer2, -blockSizeVert, moveVert,
				MenuPlayer2.posVert === 0 ? false : Directions.Top);
		break;
	case MenuMove.Right2:
		moveMenuPlayer(MenuPlayer2, blockSizeHoriz, moveHoriz,
				MenuPlayer2.posHoriz === 3 ? false : Directions.Right);
		break;
	case MenuMove.Down2:
		moveMenuPlayer(MenuPlayer2, blockSizeVert, moveVert,
				MenuPlayer2.posVert === 1 ? false : Directions.Bottom);
		break;
	case 13:
		setMenuChoice(2);
		setMenuChoice(1);
		break;

	}
};

function setMenuChoice(player) {
	if (gameState != gameStateEnum.menuActive)
		return;

	if (player === 1) {

		fixPlayerMenuChoice(1);
	} else {

		fixPlayerMenuChoice(2);
	}
	if (playerOne.menuChosen && playerTwo.menuChosen) {
		
		buildUIForPlayers();
		
		startGame();
	}
}

function buildUIForPlayers() {
	var spriteOne = charArray[MenuPlayer1.posVert][MenuPlayer1.posHoriz];
	var spriteTwo = charArray[MenuPlayer2.posVert][MenuPlayer2.posHoriz];
	$('#namePlayer1').text(spriteOne);
	$('#namePlayer2').text(spriteTwo);
	
	setPlayerSprite(Figures.ryuSprite, spriteOne);
	setPlayerSprite(Figures.liSprite, spriteTwo);
}

function fixPlayerMenuChoice(player) {

	var pl1 = charArray[MenuPlayer1.posVert][MenuPlayer1.posHoriz];
	var pl2 = charArray[MenuPlayer2.posVert][MenuPlayer2.posHoriz];

	if (player === 1) {
		if (pl1 != "Ryu" && pl1 != "ChunLi")
			return;

		$('#playerDescr1').addClass('menuPlayerChosen');
		$('#menuPlayer1').addClass('menuPlayerChosen');
		playerOne.menuChosen = true;
	} else {
		if (pl2 != "Ryu" && pl2 != "ChunLi")
			return;

		$('#playerDescr2').addClass('menuPlayerChosen');
		$('#menuPlayer2').addClass('menuPlayerChosen');
		playerTwo.menuChosen = true;
	}
}

function moveMenuPlayer(player, direction, margin, allowed) {

	// check if already chosen
	if (playerOne.menuChosen && player.id === 1)
		return;

	if (playerTwo.menuChosen && player.id === 2)
		return;

	if (!allowed)
		return;
	else {
		switch (allowed) {

		case Directions.Left:
			player.posHoriz--;
			break;
		case Directions.Right:
			player.posHoriz++;
			break;
		case Directions.Top:
			player.posVert--;
			break;
		case Directions.Bottom:
			player.posVert++;
			break;

		}
	}

	var temp = $(player.div).css(margin);
	temp = temp.substring(0, temp.length - 2);
	$(player.div).css(margin, (Number(temp) + Number(direction)) + "px");

}


