﻿using GameLibrary;
using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace GameServer
{
    static class MapGenerator
    {
        public static Tile[,] RandomMap(int xsize,int ysize)
        {
            const int MAX = 32;
            
            Tile[,] tiles = new Tile[ysize, xsize];
            var r = new Random();
            for (int i = 0; i < ysize; i++)
            {
                for (int j = 0; j < xsize; j++)
                {
                    tiles[i, j] = new Tile();
                    tiles[i, j].X = (byte)r.Next(MAX);
                    tiles[i, j].Y = (byte)r.Next(MAX);
                    tiles[i, j].Dir = (byte)r.Next(3);
                }
            }
            return tiles;
        }
        public static Tile[,] getMapfromImage(Bitmap bmp)
        {
            int xsize = bmp.Width;
            int ysize = bmp.Height;
            Tile[,] tiles = new Tile[ysize, xsize];

            for (int i = 0; i < ysize; i++)
            {
                for (int j = 0; j < xsize; j++)
                {
                    int data = bmp.GetPixel(j, i).ToArgb();
                    var t = new Tile();
                    t.Dir = data >> 0 & 0xFF;
                    t.Y = data >> 8 & 0xFF;
                    t.X = data >> 16 & 0xFF;
                    t.Passable = data >> 24 & 0xFF;
                    tiles[i, j] = t;
                    //Console.WriteLine(t.X + " " + t.Y);
                }
            }
            return tiles;
        }
    }
}
