﻿using GameLibrary;
using SdlDotNet.Graphics;
using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace GameClient
{
    class EntityPainter : Painter
    {
        public string ID
        {
            get;
            set;
        }
        int frame = 0;
        Entity e;
        Screen s;
        Point center;

        public EntityPainter(Screen s,Entity e,Point center)
        {
            this.s = s;
            ID = e.Id;
            this.e = e;
            this.center = center;
        }
        public void Update(Entity e,Point center)
        {
            this.e = e;
            this.center = center;
        }

        public override void Draw()
        {
            var spritesheet = s.Spritesheets["Player"];
            Surface sprite = spritesheet.GetFrame(frame, 0, e.Dir);
            frame = 0;
            var x = e.X - center.X + s.Width / 2;
            var y = e.Y - center.Y + s.Height / 2;
            var pos = new Point(x - sprite.Width / 2,y - sprite.Height / 2);
            s.Buffer.Blit(sprite, pos);
        }
    }
}
