﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Drawing;
using GameLibrary;

namespace GameClient
{
    class MapPainter : Painter
    {
        const int TILESIZE = 40;
        const double MAXZOOM = 1;
        const double MINZOOM = 0.25;
        double zoom;
        public Point Center
        {
            get;
            set;
        }
        public double Zoom
        {
            get { return zoom; }
            set 
            {
                zoom = value;
                if (zoom > MAXZOOM) zoom = MAXZOOM;
                if (zoom < MINZOOM) zoom = MINZOOM;
            }
        }
        Screen s;
        Tile[,] map;
        public MapPainter(Screen s,Tile[,] map)
        {
            Center = new Point(0, 0);
            Zoom = 1;
            this.s = s;
            this.map = map;
        }
        public MapPainter(Screen s,Map map)
        {
            Center = new Point(0, 0);
            Zoom = 1;
            this.s = s;
            this.map = new Tile[map.Ysize, map.Xsize];
            for (int i = 0; i < map.Ysize; i++)
            {
                for (int j = 0; j < map.Xsize; j++)
                {
                    this.map[i, j] = map.Tiles[i * map.Ysize + j];
                }
            }
        }
        Tile getTile(int x, int y)
        {
            if (x < 0 || y < 0 || x >= map.GetLength(1) || y >= map.GetLength(0))
            {
                var t = new Tile();
                t.Passable = 0;
                return t;
            }
            return map[y, x];
        }

        public override void Draw()
        {
            int scaledTilesize = (int)Math.Round(Zoom * TILESIZE);
            Point topLeft = new Point(Center.X - s.Width / 2, Center.Y - s.Height / 2);
            Point topLeftTile = new Point(topLeft.X / scaledTilesize, topLeft.Y / scaledTilesize);
            Point tilesInView = new Point(s.Width / scaledTilesize + 2, s.Height / scaledTilesize + 2);
            Point offset = new Point(-topLeft.X % scaledTilesize, -topLeft.Y % scaledTilesize);
            var spritesheet = s.Spritesheets["Map"];
            for (int i = 0; i < tilesInView.Y; i++)
            {
                for (int j = 0; j < tilesInView.X; j++)
                {
                    var x=topLeftTile.X+j;
                    var y=topLeftTile.Y+i;
                    var tile = getTile(x, y);
                    var sprite = spritesheet.GetFrame(tile.X, tile.Y, tile.Dir,scaledTilesize);
                    var pos = new Point(offset.X+scaledTilesize*j,offset.Y+scaledTilesize*i);
                    s.Buffer.Blit(sprite,pos);
                }
            }
        }
    }
}
