﻿using SdlDotNet.Graphics;
using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace GameClient
{
    class Spritesheet
    {
        Surface sprite;
        public int Size
        {
            get;
            set;
        }
        public int Frames
        {
            get
            {
                return sprite.Width / Size;
            }
        }
        public Spritesheet(Bitmap image,int size,Surface screen)
        {
            Size = size;
            sprite = new Surface(image).Convert(screen, true, true);
        }
        public Spritesheet(Bitmap image, int size, Surface screen,bool transparent)
        {
            Size = size;
            sprite = new Surface(image).Convert(screen, true, true);
            sprite.ReplaceColor(Color.FromArgb(255, 0, 0, 0), Color.Empty);
            sprite.TransparentColor = Color.Empty;
            sprite.Transparent = transparent;
        }
        public Surface GetFrame(int x, int y)
        {
            var clip = new Rectangle(x * Size, y * Size, Size, Size);
            return sprite.CreateSurfaceFromClipRectangle(clip);
        }
        public Surface GetFrame(int x)
        {
            return GetFrame(x, 0);
        }
        public Surface GetFrame(int x, int y, int dir)
        {
            //fix rotation
            return GetFrame(x, y);
        }
        public Surface GetFrame(int x, int y, double rotation)
        {
            //changes size
            var angle = -rotation*180/Math.PI;
            var frame = GetFrame(x, y).CreateRotatedSurface((int)angle);
            frame.Transparent = true;
            return frame;
        }
        public Surface GetFrame(int x, int y, int dir, int newsize)
        {
            return GetFrame(x, y, dir).CreateResizedSurface(new Size(newsize, newsize));
        }
    }
}
