﻿using ProtoBuf;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace GameLibrary
{
    [ProtoContract]
    [ProtoInclude(6,typeof(Player))]
    public abstract class Entity
    {
        [ProtoMember(1)]
        public string Id
        {
            get;
            set;
        }
        [ProtoMember(2)]
        public int X
        {
            get { return (int)x; }
            set { x = value; }
        }
        [ProtoMember(3)]
        public int Y
        {
            get { return (int)y; }
            set { y = value; }
        }
        [ProtoMember(4)]
        public double Dir
        {
            get { return dir; }
            set { dir = value; }
        }
        [ProtoMember(5)]
        public Dictionary<string, bool> Actions
        {
            get;
            set;
        }
        double x, y,dir;
        
        int speed = 10;
        double turnspeed = 0.1;
        public Entity()
        {
        }
        public Entity(int x,int y,double dir)
        {
            this.x = x;
            this.y = y;
            this.dir = dir;
            this.Id = Guid.NewGuid().ToString();
            Actions = new Dictionary<string, bool>()
            {
                {"forward",false},
                {"backward",false},
                {"turnLeft",false},
                {"turnRight",false}
            };
            
            
        }
        public void update()
        {
            if (Actions["forward"])
            {
                x += Math.Cos(Dir) * speed;
                y += Math.Sin(Dir) * speed;
            }
            if (Actions["backward"])
            {
                x -= Math.Cos(Dir) * speed;
                y -= Math.Sin(Dir) * speed;
            }
            if (Actions["turnLeft"])
            {
                dir -= turnspeed;
                
            }
            if (Actions["turnRight"])
            {
                dir += turnspeed;
            }
            
        }
        
        
        
    }
}
