﻿using ProtoBuf;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace GameLibrary
{
    [ProtoContract]
    public class Map
    {
        [ProtoMember(1)]
        public Tile[] Tiles{
            get;
            set;
        }
        [ProtoMember(2)]
        public int Xsize
        {
            get;
            set;
        }
        [ProtoMember(3)]
        public int Ysize
        {
            get;
            set;
        }
        public Map()
        {
        }
        public Map(Tile[,] map)
        {
            Ysize = map.GetLength(0);
            Xsize = map.GetLength(1);
            Tiles = new Tile[Ysize * Xsize];
            for (int i = 0; i < Ysize; i++)
            {
                for (int j = 0; j < Xsize; j++)
                {
                    Tiles[i * Ysize + j] = map[i, j];
                }
            }
        }

    }
}
