﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace GameServer
{
    public partial class GameServer : Form
    {
        ConnectionHandler connections;
        public GameServer()
        {
            InitializeComponent();
            connections = new ConnectionHandler();
            connections.connectionChange += connections_connectionChange;
            connections.connectionChange += Game.Current.ClientChange;
            Game.Current.GameChange += onGameChange;
            
        }

        private void onGameChange(object sender, GameChangeEventArgs e)
        {
            if (!IsHandleCreated) return;
            Invoke((MethodInvoker)delegate
            {
                if (e.Running)
                {
                    gameState.Text = "Game in progress...";
                    progressBar.Style = ProgressBarStyle.Marquee;
                }
                else
                {
                    gameState.Text = "Game not running";
                    progressBar.Style = ProgressBarStyle.Continuous;
                }
            });
        }
        
        void connections_connectionChange(ConnectionHandler sender, ConnectionChangeEventArgs e)
        {
            Invoke((MethodInvoker)delegate
            {
                ConnectionList.Items.Clear();
                var clients = e.Clients.Values;
                foreach( var client in clients)
                {
                    ListViewItem item = new ListViewItem();
                    item.Text = client.EndPoint.ToString();
                    item.SubItems.Add(DateTime.Now.ToString());
                    item.SubItems.Add(client.ID);
                    ConnectionList.Items.Add(item);
                }
                
            });
            
        }
    }
}
