﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Net;
using System.Net.Sockets;

namespace GameClient
{
    class Client
    {
        public string ID
        {
            get;
            private set;
        }
        public IPEndPoint EndPoint
        {
            get;
            private set;
        }
        Socket sck;
        NetworkStream ns;
        public NetworkStream Stream
        {
            get
            {
                return ns;
            }
        }

        public Client(Socket accepted)
        {
            sck = accepted;
            init();
            
        }
        public Client(string ip, int port)
        {
            sck = new Socket(AddressFamily.InterNetwork, SocketType.Stream, ProtocolType.Tcp);
            try
            {
                sck.Connect(ip, port);
                ns = new NetworkStream(sck);
                init();
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
            }
        }
        private void init()
        {
            ID = Guid.NewGuid().ToString();
            EndPoint = (IPEndPoint)sck.RemoteEndPoint;
            sck.BeginReceive(new byte[] { 0 }, 0, 0, 0, callback, null);
        }

        void callback(IAsyncResult ar)
        {
            try
            {
                sck.EndReceive(ar);
                byte[] receiveBuffer = new byte[8192];

                int recievedSize = sck.Receive(receiveBuffer, receiveBuffer.Length, 0);
                if (recievedSize == 0)
                {
                    Close();
                    return;
                }
                if (recievedSize < receiveBuffer.Length)
                {
                    Array.Resize(ref receiveBuffer, recievedSize);
                }
                if (Received != null)
                {
                    Received(this, receiveBuffer);
                }
                sck.BeginReceive(new byte[] { 0 }, 0, 0, 0, callback, null);

            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
                Close();
            }

        }
        public void Close()
        {
            sck.Close();
            sck.Dispose();
            if (Disconnected != null)
            {
                Disconnected(this);
            }
        }
        public void Send(byte[] data)
        {
                try
                {
                    sck.Send(data);
                }
                catch (Exception ex)
                {
                    Console.WriteLine(ex.Message);
                }
        }
        public void Send(string action, bool pressed)
        {
            byte[] s = System.Text.Encoding.UTF8.GetBytes(action);
            var tosend = new List<byte>();
            tosend.AddRange(BitConverter.GetBytes(pressed));
            tosend.AddRange(s);
            Send(tosend.ToArray());
        }
        public delegate void ClientReceivedHandler(Client sender, byte[] data);
        public delegate void ClientDisconnectedHandler(Client sender);

        public event ClientReceivedHandler Received;
        public event ClientDisconnectedHandler Disconnected;
    }
}
