﻿using GameLibrary;
using System;
using System.Collections.Generic;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace GameClient
{
    class StaticMap
    {
        public static Tile[,] getMap()
        {
            var xsize = 40;
            var ysize = 30;
            var max = 31;
            Tile[,] tiles = new Tile[ysize, xsize];
            var r = new Random();
            for (int i = 0; i < ysize; i++)
            {
                for (int j = 0; j < xsize; j++)
                {
                    tiles[i, j] = new Tile();
                    tiles[i, j].X = (byte)r.Next(max);
                    tiles[i, j].Y = (byte)r.Next(max);
                    tiles[i, j].Dir = (byte)r.Next(3);
                }
            }
            return tiles;
        }
        public static Tile[,] getMapFromFile(string path)
        {
            String[] a = File.ReadAllLines(path);
            var xsize = 32;
            var ysize = 32;
            Tile[,] tiles = new Tile[ysize, xsize];
            for (int i = 0; i < ysize; i++)
            {
                for (int j = 0; j < xsize; j++)
                {
                    var str = a[i*32+j];
                    var t = int.Parse(str)-1;
                    var v = t%1000;
                    if (v == 641) v -= 32;
                    tiles[i, j] = new Tile();
                    tiles[i, j].X = (byte)(v%32);
                    tiles[i, j].Y = (byte)(v/32);
                    tiles[i, j].Dir = (byte)(-t/1000);
                }
            }
            return tiles;
        }
        public static Tile[,] getMapfromImage(Bitmap bmp)
        {
            int xsize = bmp.Width;
            int ysize = bmp.Height;
            Tile[,] tiles = new Tile[ysize, xsize];

            for (int i = 0; i < ysize; i++)
            {
                for (int j = 0; j < xsize; j++)
                {
                    int data = bmp.GetPixel(j, i).ToArgb();
                    var t = new Tile();
                    t.X =   (byte)(data >> 0 & 0xFF);
                    t.Y =   (byte)(data >> 8 & 0xFF);
                    t.Dir = (byte)(data >> 16 & 0xFF);
                    t.Passable = (byte)(data >> 24 & 0xFF);
                    tiles[i, j] = t;
                }
            }
            return tiles;
        }
    }
}
