﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace GameServer
{
    class ConnectionHandler
    {
        const int PORT = 8080;
        Listener listener;
        public Dictionary<string, Client> Clients
        {
            get;
            private set;
        }
        public ConnectionHandler()
        {
            Clients = new Dictionary<string, Client>();
            listener = new Listener(PORT);
            listener.SocketAccepted += listener_SocketAccepted;
            listener.Start();
        }

        void listener_SocketAccepted(object sender, SocketAcceptedEventArgs e)
        {
            Client client = new Client(e.Socket);
            client.Disconnected += client_Disconnected;
            Clients.Add(client.ID, client);
            if (connectionChange != null)
            {
                connectionChange(this, new ConnectionChangeEventArgs(Clients));
            }


        }


        void client_Disconnected(Client sender)
        {
            Clients.Remove(sender.ID);
            if (connectionChange != null)
            {
                connectionChange(this, new ConnectionChangeEventArgs(Clients));
            }
        }
        public delegate void ConnectionsChangedEventHandler(ConnectionHandler sender,ConnectionChangeEventArgs e);

        public event ConnectionsChangedEventHandler connectionChange;

    }
}
