﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Threading;
using System.Diagnostics;

namespace PsychoTerror
{
    //MainWindow, von dem aus das gesamte Programm gesteuert wird
    public partial class Hauptform : Form
    {
        //Boolflags
        bool isGameRunning;
        bool infoFormIsThere;

        //Spielelemente
        BildBuffer bildBuffer;
        Level level;
        SpielFigur spielFigur;
        Verfolger verfolger;
        Infoform infoform;

        //Konstruktor
        public Hauptform()
        {
            InitializeComponent();

            passeFenstergroesseAn();

            //Erzeuge Spielelemente
            level = new Level();
            spielFigur = new SpielFigur(level);
            verfolger = new Verfolger();

            this.Text = "PsychoTerror - Das Spiel!";
            makeInlevelItemsInvisible();

            isGameRunning = false;
            infoFormIsThere = false;
            bildBuffer = new BildBuffer(SynchronizationContext.Current, spielFigur, level, verfolger);
            bildBuffer.MaleBildEvent += new BildBuffer.MaleBild(buffer_MaleBildEvent);
            bildBuffer.NextLevelEvent += new BildBuffer.Sonstiges(bildBuffer_NextLevelEvent);
            bildBuffer.SterbeEvent += new BildBuffer.Sonstiges(bildBuffer_SterbeEvent);
            this.Deactivate += new EventHandler(Hauptform_Deactivate);
        }

        void Hauptform_Deactivate(object sender, EventArgs e)   //Falls eine Taste gedrückt war und der Focus weggeht, 
        {                                                       //läuft bzw. springt die Figur nicht weiter
            spielFigur.RechtsInit = false;
            spielFigur.LinksInit = false;
            spielFigur.JumpInit = false;
        }

        void buffer_MaleBildEvent(BildBuffer sender, Bitmap b)  //Malt das Bild ins Fenster
        {
            if (isGameRunning)
            {
                pictureBox.Image = b;
            }
        }

        void bildBuffer_NextLevelEvent(BildBuffer sender, object o) //Bei Levelende zum nächsten Level oder Spielende
        {
            level.LevelNummer += 1;

            if (level.LevelNummer > level.LevelAnzahl)  //Spiel gewonnen
            {
                level.Gewonnen = true;
                StartGameItem.Enabled = true;
                levelItemsDisable();
                this.Text = "PsychoTerror - Gewonnen!";
                makeInlevelItemsInvisible();
            }
            else //zum nächsten Level
            {
                switch (level.LevelNummer)  //Buttons für Levelshortcuts freischalten
                { 
                    case 5:
                        level.Level5Erreicht = true;
                        break;
                    case 10:
                        level.Level10Erreicht = true;
                        break;
                    case 15:
                        level.Level15Erreicht = true;
                        break;
                }
                levelItemsEnable();
                verfolger.X = -50;  //Setze Verfolger an den Levelanfang
                verfolger.XSpeed = 0;
                showLevelItem.Text = "Level: " + level.LevelNummer;
                spielFigur.LevelAnfang = true;  //Setze Spielfigur an den Levelanfang
            }
        }

        //Spielfigur berührt etwas Rotes => Ein Leben weniger
        void bildBuffer_SterbeEvent(BildBuffer sender, object o)
        {
            if (spielFigur.Lives > 0)   //Wenn noch genug Leben da sind, ziehe eins ab
            {
                spielFigur.Lives -= 1;
                verfolger.X = -50;
                verfolger.XSpeed = 0;
                showLivesItem.Text = "Lives: " + spielFigur.Lives;
                spielFigur.LevelAnfang = true;  //Setze Spielfigur an den Levelanfang 
            }
            else //Wenn das nullte Leben schon angebrochen war, Spiel verloren
            {
                level.Verloren = true;
                makeInlevelItemsInvisible();
                this.Text = "PsychoTerror - Verloren!";
                StartGameItem.Enabled = true;
                levelItemsDisable();
            }
        }

        private void StartGameItem_Click(object sender, EventArgs e)    //Startet das Spiel per Buttonclick
        {
            //Stelle alle Parameter auf Spielanfang
            this.Text = "PsychoTerror - Go go go!";
            spielFigur.Lives = 5;
            level.LevelNummer = 1;
            verfolger.X = -50;
            verfolger.XSpeed = 0;
            makeInlevelItemsVisible();
            showLivesItem.Text = "Lives: " + spielFigur.Lives;
            showLevelItem.Text = "Level: " + level.LevelNummer;
            StartGameItem.Enabled = false;
            level.Gewonnen = false;
            level.Verloren = false;
            spielFigur.LevelAnfang = true;
            level.SkippedLevels = true;
            levelItemsEnable();

            if (!isGameRunning) //Wenn in derselben Programmsession noch kein Spiel gestartet wurde
            {
                bildBuffer.StartThread();
                isGameRunning = true;
            }
        }

        private void EndGameItem_Click(object sender, EventArgs e)  //Spiel beenden
        {
            this.Close();
        }

        private void Hauptform_KeyDown(object sender, KeyEventArgs e)   //Liest Tastendruck ein und reagiert entsprechend
        {
            if (isGameRunning == false) return;     //reagiere nur, wenn das Spiel läuft

            switch(e.KeyData)
            {
                case Keys.Right:
                    spielFigur.RechtsInit = true;
                    break;
                case Keys.Left:
                    spielFigur.LinksInit = true;
                    break;
                case Keys.Up:
                    spielFigur.JumpInit = true;
                    break;
            }
        }

        //if-Abfragen im folgenden sind für flüssige Bewegungen nötig
        private void Hauptform_KeyUp(object sender, KeyEventArgs e) //Keine Taste gedrückt, Figur steht
        {
            switch (e.KeyData)
            {
                case Keys.Right:
                    if (spielFigur.RechtsInit == true)
                        spielFigur.RechtsInit = false;
                    break;
                case Keys.Left:
                    if (spielFigur.LinksInit == true)
                        spielFigur.LinksInit = false;
                    break;
                case Keys.Up:
                    if (spielFigur.JumpInit == true)
                        spielFigur.JumpInit = false;
                    break;
            }
        }

        //Shortcuts zu freigeschalteten Levels
        private void toLevelItem5_Click(object sender, EventArgs e)
        {
            goToLevel(5);
        }
        private void toLevelItem10_Click(object sender, EventArgs e)
        {
            goToLevel(10);
        }
        private void toLevelItem15_Click(object sender, EventArgs e)
        {
            goToLevel(15);
        }
        void goToLevel(int lev)
        {
            level.LevelNummer = lev;
            verfolger.X = -50;
            verfolger.XSpeed = 0;
            showLevelItem.Text = "Level: " + level.LevelNummer;
            spielFigur.LevelAnfang = true;  //Setze Spielfigur an den Levelanfang
            level.SkippedLevels = true;
        }

        //Shortcuts zu Levels nicht klickbar
        void levelItemsDisable()
        {
            toLevelItem5.Enabled = false;
            toLevelItem10.Enabled = false;
            toLevelItem15.Enabled = false;
        }

        //Freigeschaltete Shortcuts klickbar
        void levelItemsEnable()
        {
            if(level.Level5Erreicht)
                toLevelItem5.Enabled = true;
            if(level.Level10Erreicht)
                toLevelItem10.Enabled = true;
            if(level.Level15Erreicht)
                toLevelItem15.Enabled = true;
        }

        //Zeige Infoform, wenn Infoitem geklickt
        //Infoform soll Steuerbarkeit des Spiels nicht beeinflussen
        //Infoform wird nur einmal angezeigt und danach bei Bedarf sichtbar gemacht
        private void infoItem_Click(object sender, EventArgs e)
        {
            if (!infoFormIsThere)
            {
                infoform = new Infoform(this);
                infoform.Show();
                infoFormIsThere = true;
            }
            else
            {
                infoform.BringToFront();
            }
        }
        public void resetInfoItem()
        {
            infoFormIsThere = false;
        }

        //Diese Elemente sollen nur bei laufendem Spiel gezeigt werden
        void makeInlevelItemsInvisible() 
        {
            showLevelItem.Visible = false;
            showLivesItem.Visible = false;
        }
        void makeInlevelItemsVisible()
        {
            showLevelItem.Visible = true;
            showLivesItem.Visible = true;
        }

        //Beim Testen herausgefunden, dass die Anzeige bei verschiedenen Bildschirmauflösungen in Ordnung ist.
        //Auf unterschiedlichen Rechnern ist aber manchmal das Fenster zu groß für die pictureBox.
        //Das könnte an unterschiedlichen DPI-Zahlen liegen.
        //Bisher 96x96 und 120x120 DPI getestet. Dabei funktioniert folgende Anpassung.
        void passeFenstergroesseAn()
        {
            float dx, dy;
            Graphics g = this.CreateGraphics();
            try
            {
                dx = g.DpiX;
                dy = g.DpiY;
            }
            finally
            {
                g.Dispose();
            }

            if (dx == 96 && dy == 96)
            {
                this.Width = Program.BILDBREITE + 8;
                this.Height = Program.BILDHOEHE + 58;
            }
            if (dx == 120 && dy == 120)
            {
                this.Width = Program.BILDBREITE + 18;
                this.Height = Program.BILDHOEHE + 73;
            }
        }
    }
}
