﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace RunningGame
{
    public partial class CharacterForm : Form
    {
        SettingsForm settingsForm;
        Object choosingPlayer;

        // Properties for handling different Screens/DPIs
        SizeF currentScaleFactor = new SizeF(1f, 1f);

        public CharacterForm(SettingsForm settingsForm, Object sender)
        {
            InitializeComponent();
            this.settingsForm = settingsForm;
            choosingPlayer = sender;
            pictureBox1.Image = new Bitmap(Resources.face_mario, new Size(
                (int)Math.Round(Resources.face_mario.Width * this.currentScaleFactor.Width),
                (int)Math.Round(Resources.face_mario.Width * this.currentScaleFactor.Width)));
            pictureBox2.Image = new Bitmap(Resources.face_monster, new Size(
                (int)Math.Round(Resources.face_monster.Width * this.currentScaleFactor.Width),
                (int)Math.Round(Resources.face_monster.Width * this.currentScaleFactor.Width)));
            pictureBox3.Image = new Bitmap(Resources.faceb_sonic, new Size(
                (int)Math.Round(Resources.faceb_sonic.Width * this.currentScaleFactor.Width),
                (int)Math.Round(Resources.faceb_sonic.Width * this.currentScaleFactor.Width)));
        }

        /// <summary>
        /// Player chooses Mario
        /// </summary>
        private void pictureBox1_Click(object sender, EventArgs e)
        {
            SetCharacter("Mario", pictureBox1);
        }

        /// <summary>
        /// Player chooses Monster
        /// </summary>
        private void pictureBox2_Click(object sender, EventArgs e)
        {
            SetCharacter("Monster", pictureBox2);
        }

        /// <summary>
        /// Player chooses Sega
        /// </summary>
        private void pictureBox3_Click(object sender, EventArgs e)
        {
            SetCharacter("Sonic", pictureBox3);
        }

        private void SetCharacter(string character, PictureBox pb)
        {
            if (choosingPlayer == settingsForm.CharPicturePlayer1)
            {
                settingsForm.CharPicturePlayer1.Image = pb.Image;
                settingsForm.ChosenCharacter[0] = character;
                settingsForm.Enabled = true;
                this.Close();
            }
            else
            {
                settingsForm.CharPicturePlayer2.Image = pb.Image;
                settingsForm.ChosenCharacter[1] = character;
                settingsForm.Enabled = true;
                this.Close();
            }
        }

        private void CharacterForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            settingsForm.Enabled = true;
        }

        /// <summary>
        /// Overriding scale control method to have the same scaling on monitors with different DPIs
        /// </summary>
        /// <param name="factor"></param>
        /// <param name="specified"></param>
        protected override void ScaleControl(SizeF factor, BoundsSpecified specified)
        {
            base.ScaleControl(factor, specified);

            // record the running scale factor used
            this.currentScaleFactor = new SizeF(
                this.currentScaleFactor.Width * factor.Width,
                this.currentScaleFactor.Height * factor.Height);
        }
    }
}
