﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace RunningGame
{
    public partial class SettingsForm : Form
    {
        CharacterForm characterForm;
        InfoForm infoForm;
        string[] chosenCharacter;

        // Properties for handling different Screens/DPIs
        SizeF currentScaleFactor = new SizeF(1f, 1f);

        #region Getters and Setters

        public PictureBox CharPicturePlayer1
        {
            get { return charPicturePlayer1; }
            set { charPicturePlayer1 = value; }
        }

        public PictureBox CharPicturePlayer2
        {
            get { return charPicturePlayer2; }
            set { charPicturePlayer2 = value; }
        }

        public string[] ChosenCharacter
        {
            get { return chosenCharacter; }
            set { chosenCharacter = value; }
        }

        //public TextBox DistanceTextBox
        //{
        //    get { return distanceTextBox; }
        //    set { distanceTextBox = value; }
        //}

        #endregion

        public SettingsForm()
        {
            InitializeComponent();
            chosenCharacter = new string[2];
            // Default values
            //gameModeComboBox.SelectedIndex = 0;
            chosenCharacter[0] = "Mario";
            chosenCharacter[1] = "Monster";
            namePlayer1TextBox.Text = "Player 1";
            namePlayer2TextBox.Text = "Player 2";
            //distanceTextBox.Text = "2000";
            charPicturePlayer1.Image = Resources.face_mario;
            charPicturePlayer2.Image = Resources.face_monster;
        }

        private void startButton_Click(object sender, EventArgs e)
        {
            this.Hide();

            //Character charPlayer1 = GetChosenCharacter(chosenCharacter[0]);
            Character charPlayer1 = new Character(chosenCharacter[0]);
            Player player1 = new Player(namePlayer1TextBox.Text, charPlayer1);
            
            //Character charPlayer2 = GetChosenCharacter(chosenCharacter[1]);
            Character charPlayer2 = new Character(chosenCharacter[1]);
            Player player2 = new Player(namePlayer2TextBox.Text, charPlayer2);
            new GameForm(this, player1, player2).Show();
        }

        private void charPicturePlayer1_Click(object sender, EventArgs e)
        {
            this.Enabled = false;
            characterForm = new CharacterForm(this, sender);
            characterForm.Show();      
        }

        private void charPicturePlayer2_Click(object sender, EventArgs e)
        {
            this.Enabled = false;
            characterForm = new CharacterForm(this, sender);
            characterForm.Show();
        }

        private void quitButton_Click(object sender, EventArgs e)
        {
            Application.Exit();
        }

        /// <summary>
        /// Overriding scale control method to have the same scaling on monitors with different DPIs
        /// </summary>
        /// <param name="factor"></param>
        /// <param name="specified"></param>
        protected override void ScaleControl(SizeF factor, BoundsSpecified specified)
        {
            base.ScaleControl(factor, specified);

            // record the running scale factor used
            this.currentScaleFactor = new SizeF(
                this.currentScaleFactor.Width * factor.Width,
                this.currentScaleFactor.Height * factor.Height);
        }

        private void button1_Click(object sender, EventArgs e)
        {
            this.Enabled = false;
            infoForm = new InfoForm(this);
            infoForm.Show();
        }
    }
}
