﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace RunningGame
{
    /// <summary>
    /// A class representing a running character
    /// </summary>
    public class Character
    {
        private string name;
        private string description;
        private int speed;

        // Properties needed to render the character in the GameForm
        private Bitmap spriteSheet;
        private int spriteWidth;
        private int spriteHeight;
        int sprites;
        
        private Skill skill;

        public Character(string characterName)
        {
            this.name = characterName;
            switch (characterName)
            {
                case "Mario": 
                    this.spriteSheet = Resources.sprite_mario;
                    this.spriteWidth = 55;
                    this.spriteHeight = 72;
                    this.sprites = 5;
                    break;
                case "Monster":
                    this.spriteSheet = Resources.sprite_runner_monster;
                    this.spriteWidth = 70;
                    this.spriteHeight = 70;
                    this.sprites = 7;
                    break;
                case "Sonic":
                    this.spriteSheet = Resources.sprite_sonic_red;
                    this.spriteWidth = 36;
                    this.spriteHeight = 58;
                    this.sprites = 7;
                    break;
                default:
                    this.spriteSheet = Resources.sprite_mario;
                    this.spriteWidth = 55;
                    this.spriteHeight = 72;
                    this.sprites = 5;
                    break;
            }

        }

        # region Getters and setters

        public string Name
        {
            get { return name; }
            set { name = value; }
        }

        public string Description
        {
            get { return description; }
            set { description = value; }
        }

        public int Speed
        {
            get { return speed; }
            set { speed = value; }
        }

        public Bitmap SpriteSheet
        {
            get { return spriteSheet; }
            set { spriteSheet = value; }
        }

        public int SpriteWidth
        {
            get { return spriteWidth; }
            set { spriteWidth = value; }
        }

        public int SpriteHeight
        {
            get { return spriteHeight; }
            set { spriteHeight = value; }
        }

        public Skill Skill
        {
            get { return skill; }
            set { skill = value; }
        }

        public int Sprites
        {
            get { return sprites; }
            set { sprites = value; }
        }

        # endregion
    }
}
