﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace RunningGame
{
    /// <summary>
    /// This class represents the human player.
    /// It properties contain e.g. the current speed, current position and the game character chosen.
    /// </summary>
    public class Player
    {
        string name;
        int speed;
        int xCoordinate;
        PlayerState state;
        bool blockEnabled;
        bool blockProtectionEnabled;
        bool blockProtectionActivated;
        int blockProtectionTime;
        Character character;
        int playerImageIndex;
        int imgChangeInterval;
        int timeTillImgChange;

        public Player(string name, Character character)
        {
            this.name = name;            
            speed = 0;
            xCoordinate = 0;
            state = PlayerState.Standing;
            timeTillImgChange = 0;
            playerImageIndex = 0;
            blockEnabled = true;
            blockProtectionEnabled = true;
            blockProtectionActivated = false;
            blockProtectionTime = 2000;
            this.character = character;
        }

        #region Getters and setters

        public string Name
        {
            get { return name; }
            set { name = value; }
        }

        public int Speed
        {
            get { return speed; }
            set { speed = value; }
        }

        public int XCoordinate
        {
            get { return xCoordinate; }
            set { xCoordinate = value; }
        }

        public PlayerState State
        {
            get { return state; }
            set { state = value; }
        }

        public Character Character
        {
            get { return character; }
            set { character = value; }
        }

        public int ImgChangeInterval
        {
            get { return imgChangeInterval; }
            set { imgChangeInterval = value; }
        }

        public int TimeTillImgChange
        {
            get { return timeTillImgChange; }
            set { timeTillImgChange = value; }
        }

        public int PlayerImageIndex
        {
            get { return playerImageIndex; }
            set { playerImageIndex = value; }
        }

        public bool BlockEnabled
        {
            get { return blockEnabled; }
            set { blockEnabled = value; }
        }

        public bool BlockProtectionEnabled
        {
            get { return blockProtectionEnabled; }
            set { blockProtectionEnabled = value; }
        }

        public bool BlockProtectionActivated
        {
            get { return blockProtectionActivated; }
            set { blockProtectionActivated = value; }
        }

        public int BlockProtectionTime
        {
            get { return blockProtectionTime; }
            set { blockProtectionTime = value; }
        }

        # endregion

        public override string ToString()
        {
            return "{ Name: " + Name + ", X-Coordinate: " + xCoordinate + ", Speed: " + Speed + " }";
        }
    }

    public enum PlayerState
    { 
        Standing,
        StepRight,
        StepLeft,
        Jumping,
        Blocked
    }
}
