﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Sudoku
{
    public partial class SolutionForm : Form
    {

        // Lösung in neuem Fenster anzeigen

        public SolutionForm(TableLayoutPanel field, byte[,] solution)
        {
            InitializeComponent();
            newField.RowCount = Globals.SIZE;
            newField.ColumnCount = Globals.SIZE;
            this.newField.Size = new System.Drawing.Size(Globals.SIZE * 25 + (Globals.SIZE + 1) * 3, Globals.SIZE * 25 + (Globals.SIZE + 1) * 3);
            this.Size = new System.Drawing.Size(Globals.SIZE * 25 + (Globals.SIZE + 1) * 3 + 80, Globals.SIZE * 25 + (Globals.SIZE + 1) * 3 + 80);

            for (int i = 0; i < Globals.SIZE; i++)
                for (int j = 0; j < Globals.SIZE; j++)
                {
                    System.Windows.Forms.Label label = new System.Windows.Forms.Label();
                    label.Name = "label" + i + j;
                    this.newField.Controls.Add(label, i, j);
                    label.Size = new System.Drawing.Size(19, 20);
                    label.TabIndex = (i + 1) + Globals.SIZE * j;
                    label.Dock = DockStyle.Bottom;
                }

            Control cNew;
            Control c;

            if (field.GetControlFromPosition(0, 0) != null)
            {
                for (int i = 0; i < Globals.SIZE; i++)
                    for (int j = 0; j < Globals.SIZE; j++)
                    {
                        cNew = newField.GetControlFromPosition(j, i);
                        c = field.GetControlFromPosition(j, i);

                        cNew.Text = c.Text;
                        if (c.BackColor == Color.Yellow)
                            cNew.ForeColor = Color.Orange;
                        if (cNew.Text == "")
                        {
                            cNew.Text = "" + solution[i, j];
                            cNew.ForeColor = Color.Red;
                        }
                    }
            }
            else
                this.Close();
        }


        private void newField_Paint(object sender, PaintEventArgs e)
        {
            Graphics g = e.Graphics;
            Pen pen = new Pen(Color.Gray, 2f);

            for (int i = 0; i < Globals.BOXSIZE; i++)
                for (int j = 0; j < Globals.BOXSIZE; j++)
                {
                    g.DrawRectangle(pen, new Rectangle(2 + i * 28 * Globals.BOXSIZE, 2 + j * 28 * Globals.BOXSIZE, 28 * Globals.BOXSIZE, 28 * Globals.BOXSIZE));
                }
        }
    }
}
