﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Threading;
using System.Windows.Forms;
using System.Xml.Serialization;
using System.IO;

namespace Sudoku
{

    // Klasse zum Abspeichern und Laden des aktuellen Spielstatus

    public class SudokuInfos
    {
        public int Boxsize { get; set; }
        public List<byte> Array { get; set; }       // Listet alle eingetragenen Zeichen auf
        public List<Point> Labels { get; set; }     // Listet die Felder auf, an denen sich Labels statt Textfeldern befinden
        public List<Point> Hints { get; set; }      // Listet die Felder auf, für die bereits Tipps gegeben wurden



        public SudokuInfos(byte[,] array, List<Point> labels, List<Point> hints)
        {
            Array = new List<byte>(Globals.TOTAL);

            for (int i = 0; i < Globals.SIZE; i++)
                for (int j = 0; j < Globals.SIZE; j++)
                    Array.Add(array[i, j]);

            Labels = labels;
            Hints = hints;
            Boxsize = Globals.BOXSIZE;
        }

        public SudokuInfos()
        {
            Array = new List<byte>();
            Labels = null;
            Hints = null;
            Boxsize = 3;
        }


        // Abspeichern als xml-Datei

        public void Save() 
        {
            SaveFileDialog dia = new SaveFileDialog();
            dia.Filter = "xml files (*.xml)|*.xml";
            dia.FilterIndex = 1;

            if (dia.ShowDialog() == DialogResult.OK)
            {
                FileStream fs = new FileStream(dia.FileName, FileMode.Create);
                XmlSerializer xml = new XmlSerializer(typeof(SudokuInfos));
                xml.Serialize(fs, this);
                fs.Close();
                MessageBox.Show("Feld gespeichert.");
            }
        }


        // Laden einer xml-Datei

        static public SudokuInfos Load()
        {
            OpenFileDialog dia = new OpenFileDialog();
            dia.Filter = "xml files (*.xml)|*.xml";
            dia.FilterIndex = 1;

            if (dia.ShowDialog() == DialogResult.OK)
            {
                FileStream fs = new FileStream(dia.FileName, FileMode.Open);
                XmlSerializer xml = new XmlSerializer(typeof(SudokuInfos));

                try
                {
                    SudokuInfos infos = xml.Deserialize(fs) as SudokuInfos;
                    Globals.BOXSIZE = infos.Boxsize;
                    infos.GetArray();
                    return infos;
                }
                catch (InvalidOperationException)
                {
                    MessageBox.Show("Fehler in der Datei!");
                }
                catch (ArgumentOutOfRangeException)
                {
                    MessageBox.Show("Fehler in der Datei!");
                }
                finally
                {
                    fs.Close();
                }
            }
            return null;
        }


        // Macht aus der Liste ein zweidimensionales Array

        public byte[,] GetArray()
        {
            var array = new byte[Globals.SIZE,Globals.SIZE];

            for (int i = 0; i < Globals.SIZE; i++)
                for (int j = 0; j < Globals.SIZE; j++)
                     array[i, j] = Array[i * Globals.SIZE + j];

            return array;
        }
    }
}
