﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace WindowsFormsApplication1
{
    public partial class Form2 : Form
    {
        public Ant ant
        {
            get;
            set;
        }
        Hilfe hilfe;
        About about;
        public Form1 form1
        {
            get;
            set;
        }
        public Daten daten
        {
            get;
            set;
        }
        bool isinlist;
        bool warningshown;
        int leftindex, rightindex;
        List<int> leftselected, rightselected;
        public Form2()
        {
            InitializeComponent();
            warningshown = false;
            comboBox1.Items.Add("Very slow");
            comboBox1.Items.Add("Slow");
            comboBox1.Items.Add("Medium");
            comboBox1.Items.Add("Fast");
            comboBox1.Items.Add("Very fast");
            comboBox1.Items.Add("ANT ON ROIDS");
        }

        private void farbzahl_ValueChanged(object sender, EventArgs e)
        {
            daten.NumberOfColors = (int)farbzahl.Value;
            List<int> removefromleft = new List<int>();
            List<int> removefromright = new List<int>();
            for (int i = 1; i <= daten.NumberOfColors; i++)
            {
                isinlist = false;
                foreach (var element in leftcolors_listbox.Items)
                {
                    if ((int)element == i)
                        isinlist = true;
                }
                foreach (var element in rightcolors_listbox.Items)
                {
                    if ((int)element == i)
                        isinlist = true;
                }
                if (!isinlist)
                    leftcolors_listbox.Items.Add(i);
            }
            foreach (var element in leftcolors_listbox.Items)
            {
                if ((int)element > daten.NumberOfColors)
                    removefromleft.Add((int)element);
            }
            foreach (var element in rightcolors_listbox.Items)
            {
                if ((int)element > daten.NumberOfColors)
                    removefromright.Add((int)element);
            }
            foreach (var element in removefromleft)
            {
                leftcolors_listbox.Items.Remove(element);
            }
            foreach (var element in removefromright)
            {
                rightcolors_listbox.Items.Remove(element);
            }
            MakeLists();
        }

        private void toright_button_Click(object sender, EventArgs e)
        {
            if (!(leftcolors_listbox.Items.Count == 1))
            {
                leftindex = leftcolors_listbox.SelectedIndex;
                leftselected = new List<int>();
                foreach (var element in leftcolors_listbox.SelectedItems)
                {
                    leftselected.Add((int)element);
                }
                foreach (var element in leftselected)
                {
                    rightcolors_listbox.Items.Add(element);
                    leftcolors_listbox.Items.Remove(element);
                }
                MakeLists();
                if (leftcolors_listbox.Items.Count == 0)
                {
                    leftcolors_listbox.Items.Add(rightcolors_listbox.Items[0]);
                    rightcolors_listbox.Items.RemoveAt(0);
                    leftcolors_listbox.SelectedIndex = 0;
                }
                else
                    if ((leftcolors_listbox.Items.Count - 1) < leftindex)
                        leftindex--;
                    leftcolors_listbox.SelectedIndex = leftindex;
            }
            else ;
        }

        private void toleft_button_Click(object sender, EventArgs e)
        {
            if (!(rightcolors_listbox.Items.Count == 1))
            {
                rightindex = rightcolors_listbox.SelectedIndex;
                rightselected = new List<int>();
                foreach (var element in rightcolors_listbox.SelectedItems)
                {
                    rightselected.Add((int)element);
                }
                foreach (var element in rightselected)
                {
                    leftcolors_listbox.Items.Add(element);
                    rightcolors_listbox.Items.Remove(element);
                }
                MakeLists();
                if (rightcolors_listbox.Items.Count == 0)
                {
                    rightcolors_listbox.Items.Add(leftcolors_listbox.Items[0]);
                    leftcolors_listbox.Items.RemoveAt(0);
                    rightcolors_listbox.SelectedIndex = 0;
                }
                else
                    if ((rightcolors_listbox.Items.Count - 1) < rightindex)
                        rightindex--;
                    rightcolors_listbox.SelectedIndex = rightindex;
            }
            else ;
        }

        private void MakeLists()
        {
            daten.LeftColors = new List<int>();
            daten.RightColors = new List<int>();
            foreach (var element in leftcolors_listbox.Items)
            {
                daten.LeftColors.Add((int)element);
            }
            daten.LeftColors.Sort();
            foreach (var element in daten.LeftColors)
            {
                leftcolors_listbox.Items.Remove(element);
            }
            foreach (var element in daten.LeftColors)
            {
                leftcolors_listbox.Items.Add(element);
            }

            foreach (var element in rightcolors_listbox.Items)
            {
                daten.RightColors.Add((int)element);
            }
            daten.RightColors.Sort();
            foreach (var element in daten.RightColors)
            {
                rightcolors_listbox.Items.Remove(element);
            }
            foreach (var element in daten.RightColors)
            {
                rightcolors_listbox.Items.Add(element);
            }
        }

        private void numericUpDown1_ValueChanged(object sender, EventArgs e)
        {
            daten.size = (int)pixelsize.Value;
        }

        private void Form2_Shown(object sender, EventArgs e)
        {
            foreach (var element in daten.LeftColors)
            {
                leftcolors_listbox.Items.Add(element);
            }
            foreach (var element in daten.RightColors)
            {
                rightcolors_listbox.Items.Add(element);
            }
            pixelsize.Value = (decimal)daten.size;
            leftcolors_listbox.SelectedIndex = 0;
            rightcolors_listbox.SelectedIndex = 0;
            comboBox1.SelectedIndex = 3;
        }

        private void leftcolors_listbox_MouseDoubleClick(object sender, MouseEventArgs e)
        {
            if (!(leftcolors_listbox.Items.Count == 1))
            {
                leftindex = leftcolors_listbox.SelectedIndex;
                rightcolors_listbox.Items.Add(leftcolors_listbox.Items[leftcolors_listbox.SelectedIndex]);
                leftcolors_listbox.Items.Remove(leftcolors_listbox.Items[leftcolors_listbox.SelectedIndex]);
                MakeLists();
                if ((leftcolors_listbox.Items.Count - 1) < leftindex)
                    leftindex--;
                leftcolors_listbox.SelectedIndex = leftindex;
            }
            else ;
        }


        private void rightcolors_listbox_MouseDoubleClick(object sender, MouseEventArgs e)
        {
            if (!(rightcolors_listbox.Items.Count == 1))
            {
                rightindex = rightcolors_listbox.SelectedIndex;
                leftcolors_listbox.Items.Add(rightcolors_listbox.Items[rightcolors_listbox.SelectedIndex]);
                rightcolors_listbox.Items.Remove(rightcolors_listbox.Items[rightcolors_listbox.SelectedIndex]);
                MakeLists();
                if ((rightcolors_listbox.Items.Count - 1) < rightindex)
                    rightindex--;
                rightcolors_listbox.SelectedIndex = rightindex;
            }
            else ;
        }

        private void comboBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (ant != null)
            {
                switch (comboBox1.SelectedIndex)
                {
                    case 0:
                        ant.speed = form1.speed = 1000;
                        break;
                    case 1:
                        ant.speed = form1.speed = 600;
                        break;
                    case 2:
                        ant.speed = form1.speed = 250;
                        break;
                    case 3:
                        ant.speed = form1.speed = 100;
                        break;
                    case 4:
                        ant.speed = form1.speed = 1;
                        break;
                    case 5:
                        if (!warningshown)
                        {
                            MessageBox.Show("ATTENTION:\n\nBy choosing this speed setting, everything will run at full throttle, your computer's power being the only limiting factor.\nAs a consequence, the whole application will eventually become unresponsive (at least until the Ant reaches one of the window's borders). Please refrain from the natural reflex to continuously click inside the main window since this will only result in the Ant doing the Walk from anew, once the commands are noticed by the system.\n\nAll in all, totally worth it! :D", "Note");
                            warningshown = true;
                        }
                        ant.speed = form1.speed = 0;
                        break;
                }
            }
            else
            {
                switch (comboBox1.SelectedIndex)
                {
                    case 0:
                        form1.speed = 1000;
                        break;
                    case 1:
                        form1.speed = 600;
                        break;
                    case 2:
                        form1.speed = 250;
                        break;
                    case 3:
                        form1.speed = 100;
                        break;
                    case 4:
                        form1.speed = 1;
                        break;
                    case 5:
                        if (!warningshown)
                        {
                            MessageBox.Show("ATTENTION:\n\nBy choosing this speed setting, everything will run at full throttle, your computer's power being the only limiting factor.\nAs a consequence, the whole application will eventually become unresponsive (at least until the Ant reaches one of the window's borders). Please refrain from the natural reflex to continuously click inside the main window since this will only result in the Ant doing the Walk from anew, once the commands are noticed by the system.\n\nAll in all, totally worth it! :D", "Note");
                            warningshown = true;
                        }
                        form1.speed = 0;
                        break;
                }
            }
        }

        private void Form2_HelpButtonClicked(object sender, CancelEventArgs e)
        {
            Cursor = DefaultCursor;
            about = new About();
            about.Show();
        }

        private void Form2_FormClosing(object sender, FormClosingEventArgs e)
        {
            form1.Close();
        }

        private void label5_MouseClick(object sender, MouseEventArgs e)
        {
            hilfe = new Hilfe();
            hilfe.Show();
        }
    }
}
