board = function(width_, height_) {
    this.width = width_;
    this.height = height_;
    this.resize = function() {
    };
    
    this.state = Array(this.width * this.height);
};

var Automaton = function(width, height, rule, custom_rule_string) {
    this.board_ = new board(width, height);
    this.setRule(rule, custom_rule_string);
};

Automaton.prototype.setRule = function(rule, custom_rule_string) {
    this.rule_name = rule;
    switch(rule) {
        case "gameoflife":
            this.transformationRule = this.transformGameOfLife;
            break;
        case "dayandnight":
            this.transformationRule = this.transformDayAndNight;
            break;
        case "seeds":
            this.transformationRule = this.transformSeeds;
            break;
        case "seedsvariation":
            this.transformationRule = this.transformSeedsVariation;
            break;
        case "highlife":
            this.transformationRule = this.transformHighLife;
            break;
        case "custom":
            this.transformationRule = this.transformCustom;
            this.custom_rule = custom_rule_string;
            break;
        default:
            this.transformationRule = this.transformGameOfLife;
    }
}

Automaton.prototype.transformHighLife = function(alive, count, neighborhood) {
    if(!alive) {
        if(count == 3 || count == 6)
            return true;
        else 
            return false;
    } else {
        if(count == 2 || count == 3)
            return true;
        else
            return false;
    }
}

Automaton.prototype.transformGameOfLife = function(alive, count, neighborhood) {
    if(!!alive) {
        if(count*1 === 2*1 || count*1 === 3*1)
            return true;
        else
            return false;
    } else {
        if(count*1 === 3*1)
            return true;
    }
};

Automaton.prototype.transformDayAndNight = function(alive, count, neighborhood) {
    if(!alive) {
        if(count == 3 || count == 6 || count == 7 || count == 8)
            return true;
    } else {
        if(count == 3 || count == 4 || count == 6 || count == 7 || count == 8)
            return true;
    }
}

Automaton.prototype.transformSeeds = function(alive, count, neighborhood) {
    if(!alive)
        if(count == 2)
            return true;
    
    return false;
}

Automaton.prototype.transformSeedsVariation = function(alive, count, neighborhood) {
    if(!alive)
        if(count == 2 && !neighborhood[5] && !neighborhood[0])
            return true;
    
    return false;
}

Automaton.prototype.transformCustom = function(alive, count, neighborhood) {
   //return  eval("var counter = 0;neighborhood.forEach(function(field) {if(field)counter++;});if(!!alive) {if(counter*1 === 2*1 || counter*1 === 3*1)true;else false;}else{if(counter*1 === 3*1)true;}");
    return eval(this.custom_rule);
}

Automaton.prototype.generateURL = function() {
    // Get the base url (until before first argument)
    var index_parameters = window.location.href.indexOf('?');
    var base_url = "";
    
    if(index_parameters != -1)
        base_url = window.location.href.substring(0, index_parameters);
    else
        base_url = window.location.href;       
    
    base_url += "?" + "&width=" + this.board_.width + "&height=" + this.board_.height;
    
    // Generate string of 0s and 1s which represents the state. Could be shortened
    // by using a base10 number system or even base34 (numbers + alphabet charachters)
    var state_string = "";
    for(var i = 0; i < this.board_.width * this.board_.height; ++i) {
        if(this.board_.state[i])
            state_string += "1";
        else
            state_string += "0";
    }
    
    base_url += "&rule=" + this.rule_name;
    
    base_url += "&state=" + state_string;
    
    console.log(base_url);
    return base_url;
};

Automaton.prototype.setStateFromString = function(state_string) {
    for(var i = 0; i < this.board_.width * this.board_.height; ++i) {
        // In case the string is too short the remaining fields will be set to false
        if(state_string.charAt(i) == "1")
            this.board_.state[i] = true;
        else
            this.board_.state[i] = false;
            
    }
};

Automaton.prototype.transform = function() {
    var next_state = [];
    // Aufruf der übergangsfuntion mit einem Array der Länge 8.
    // Beginnend mit der linken oberen Ecke nummeriert der Index des Arrays
    // die Zellen in der Nachbarschaft der zu überprüfenden Zelle im 
    // Uhrzeigersinn. Das jeweilige Feld im Array ist false, falls
    // die Zelle, die es beschreiben würde, nicht exisitiet (Rand) oder
    // falls die Zelle, die es beschreiben würde, ungesetzt ist. 
    // Ansonsten ist der Wert des Feldes true.
    // Der Rückgabewert der Funktion bestimmt, ob das Feld im kommenden
    // Zustand gesetzt oder ungesetzt ist.
    
    for(var i = 0; i < this.board_.width * this.board_.height; ++i) {
        var neighborhood = [];
                
        var iterator = [
            i - this.board_.width - 1, // topleft
            i - this.board_.width,     // top
            i - this.board_.width + 1, // topright
            i + 1,                     // right
            i + this.board_.width + 1, // bottomright
            i + this.board_.width,     // bottom
            i + this.board_.width - 1, // bottomleft
            i - 1                      // left
        ];
        
        // If the current field is on the right/left boader make their left/right 
        // neighborhood point to an index which yields undefined. No need to check for top/bottom
        // borders because these are constrained by the array length anyway
        if((i+1) % this.board_.width == 1) // left border field
            iterator[0] = iterator[6] = iterator[7] = -1;
        else if ((i+1) % this.board_.width == 0) // right border field
            iterator[2] = iterator[3] = iterator[4] = -1;
                      
        // Iterate over the neighborhood on the board and store the values in the neighborhood
        // array to be passed on to the transformationRule.
        iterator.forEach(function (field, index) {
            neighborhood[index] = this.board_.state[field];
        }, this);
        
        var count = 0;
        neighborhood.forEach(function(field) {
            if(field)
            count++;
        });
        
        next_state[i] = this.transformationRule(this.board_.state[i], count, neighborhood);
        alive = this.board_.state[i];
    }
    // Make the next state the current state.
    this.board_.state = next_state;
};

Automaton.prototype.toggle = function(index) {
    this.board_.state[index] = !this.board_.state[index];
};
    
var fromURL = function(url) {
    var width = Number(getUrlParam(url, "width"));
    var height = Number(getUrlParam(url, "height"));

    var retval = new Automaton(width, height);
    var state_string = getUrlParam(url, "state");
    retval.setRule(getUrlParam(url, "rule"));
    retval.setStateFromString(state_string);
    
    return retval;
};

Automaton.prototype.clone = function() {
    var retval = new Automaton(this.board_.width, this.board_.height);
    retval.board_.state = this.board_.state;
    return retval;
}
