var Space = function(interval_time_) {
    this.interval = null;
    this.interval_time = interval_time_;
    this.automata = [];
    this.renderers = [];
    this.tick = 0;
    $("#tick_counter").html(this.tick);
};

Space.prototype.addAutomaton = function(a) {
    this.automata.push(a);
    if(!use_canvas)
        this.renderers.push(new CSSRenderer(a.board_.width, a.board_.height));
    else
        this.renderers.push(new CanvasRenderer(a.board_.width, a.board_.height));
    this.renderers[this.renderers.length-1].addClickHandler(a);
    this.renderAll();
};

Space.prototype.startTicker = function() {
    if(this.interval != null)
        return;
    
    var that = this;
    this.interval = setInterval(function() {that.handleTick();}, 100);
};

Space.prototype.pauseTicker = function() {
    clearInterval(this.interval);
    this.interval = null;
};

Space.prototype.handleTick = function () {
    this.tick++;
    console.log(this.tick);
    this.transformAll();
    this.renderAll();
    $("#tick_counter").html(this.tick);
};

Space.prototype.transformAll = function() {
    this.automata.forEach(function(e, i) {
       e.transform();
    }, this);
};

Space.prototype.renderAll = function() {
    this.automata.forEach(function(e, i) {
       this.renderers[i].render(e);
    }, this);
};

Space.prototype.removeAutomaton = function(automaton_) {
    var i = 0;
    for(; i < this.automata.length; ++i) {
        if(this.automata[i] == automaton_)
            break;
        if(i*1 == this.automata.length - 1) {
            i = -1;
            break;
        }
    }
    if(i > -1) {
        this.renderers[i].close();
        this.automata.splice(i, 1);
        this.renderers.splice(i, 1);
    }
    
    if(this.automata.length < 1*1) {
        this.pauseTicker();
        this.click = 0;
        $("#tick_counter").html(this.tick);
    }
}

Space.prototype.setAllRules = function() {
    this.automata.forEach(function(e, i) {
        e.setRule(global_rule, global_custom_rule);
    });
}
