var DecoratorMenu = function(decorated_) {
    var that = this;
    this.decorated = decorated_;
    this.shown = false;
    this.timeout = null;
    
    this.element = $("<div/>").addClass("decorator_menu");
    this.element.css("display", "none");
    this.element.appendTo("body");
    
    // timer
    this.decorated.element.mouseenter(function() { that.onMouseEnterDecorated(); });
    this.decorated.element.mouseleave(function() { that.onMouseLeaveDecorated(); });
    this.decorated.element.mousemove(function() { that.onMouseMoveDecorated(); });
    this.element.mouseenter(function() { that.onMouseEnter(); });
    this.element.mouseleave(function() { that.onMouseLeave(); });
    
    this.startHideTimer = function() {
        if(this.timeout != null)
            clearTimeout(this.timeout);
        this.timeout = setTimeout(function() { that.onHideTimerDone(); }, 1000);
    };

    
    this.button_close = $("<button/>").appendTo(this.element).val("Schließen").attr("data-icon", "flat-cross").attr("data-theme", "b");
    this.button_close.button({ label: "Schließen", relative:true, position:"bottom center"});
    this.button_close.attr("title", "Diesen Automaten schließen");
    this.button_close.click(function() { that.onButtonCloseClicked(); });
    
    this.button_clone = $("<button/>").appendTo(this.element).val("Klonen").attr("data-icon", "start-ticker").attr("data-theme", "b");;
    this.button_clone.button({ label: "Klonen", relative:true, position:"bottom center"});
    this.button_clone.attr("title", "Diesen Automaten klonen");
    this.button_clone.click(function() { that.onButtonCloneClicked(); });
    
    this.button_copy_url = $("<button/>").appendTo(this.element).val("Teilen").attr("data-icon", "flat-man").attr("data-theme", "b");;
    this.button_copy_url.button({ label: "Verlinken", relative:true, position:"bottom center"});
    this.button_copy_url.attr("title", "Link anzeigen");
    this.button_copy_url.click(function() { that.onButtonCopyURLClicked(); });
}

DecoratorMenu.prototype.onButtonCopyURLClicked = function() {
    //alert(s.automata[0].generateURL());
    window.prompt("Drücke Ctrl + c", this.decorated.click_handlers[0].generateURL());
};

DecoratorMenu.prototype.onButtonCloseClicked = function() {
    s.removeAutomaton(this.decorated.click_handlers[0]);
    this.hide();
}

DecoratorMenu.prototype.onButtonCloneClicked = function() {
    s.addAutomaton(this.decorated.click_handlers[0].clone());
    this.hide();
}

DecoratorMenu.prototype.onMouseMoveDecorated = function() {
    this.show();
    this.startHideTimer();
};

DecoratorMenu.prototype.onMouseEnterDecorated = function() {
    this.show();
    this.startHideTimer();
};

DecoratorMenu.prototype.onMouseLeaveDecorated = function() {
    clearTimeout(this.timeout);
    this.hide();
};

DecoratorMenu.prototype.onMouseEnter = function() {
    this.show();
}

DecoratorMenu.prototype.onMouseLeave = function() {
    this.hide();
}

DecoratorMenu.prototype.onHideTimerDone = function() {
    this.timeout = null;
    this.element.stop(true);
    this.hide();
};

DecoratorMenu.prototype.hide = function() {
    this.shown = false;
    this.element.fadeOut("fast");
};

DecoratorMenu.prototype.show = function() {
    if(this.shown == true)
        return;

    this.shown = true;

    // positioning
    this.element.css("left", this.decorated.element.position().left + this.decorated.element.width() - 5);
    this.element.css("top", this.decorated.element.position().top);
    
    //this.element.css("display", "block");
    this.element.stop(true);
    this.element.fadeIn("fast");
};
