﻿$(function () {
    var shopping = false;
    var list = loadList();
    showList();

    function loadList() {
        var n = localStorage.length;
        var item = localStorage.getItem("list");

        if (item)
            return JSON.parse(item);

        return list = {
            title: '',
            entries: [],
        };
    }

    function showList() {
        $('#list > div.entry').remove();
        $('#titel').val(list.title);

        for (var i = 0; i < list.entries.length; i++)
            addEntry(list.entries[i]);
    }

    function addEntry(entry) {// Funktion zum Hinzufügen von Listeneinträgen
        var container = $('<div>').addClass('entry').appendTo($('#cheflist #list'));
        var box = $('<input>').attr({ type: "checkbox", class: "entry box" })
            .click(function() {
                entry.state = !entry.state;
                input.css('text-decoration', entry.state ? 'line-through' : '');                
                saveList();
            }).appendTo(container);
        var input = $('<input>').attr({ type: "text", class: "entry text", placeholder: "Text eingeben" })
            .click(function() {
                if (shopping)
                    $(this).parent().children('input.entry.box').click();
            })
            .change(function() {
                entry.text = this.value;
                saveList();
            })
            .val(entry.text)
            .appendTo(container);
        $('<div>').text('-').addClass('button remove').click(function () {
            container.remove();
            var index = list.entries.indexOf(entry);
            list.entries.splice(index, 1);
            saveList();
        }).appendTo(container);

        if (entry.state) {
            box.attr('checked', 'true');
            input.css('text-decoration', 'line-through');   
        }
    }

    function saveList() {
        var content = JSON.stringify(list);
        localStorage.setItem('list', content);
    }

    // Passt die checkboxen nach Verlassen des shopping-modus an
    function shoppingExit() {
        var box = $(this).children('input.entry.box');
        var text = $(this).children('input.entry.text');
        (text.css('text-decoration') === "none") ? box.removeAttr('checked') : box.attr('checked', 'true');
    }

    $('#titel').change(function() {
        list.title = this.value;
        saveList();
    });

    $('div.button.add').click(function() {
        var entry = { text : '', state: false };
        list.entries.push(entry);
        addEntry(entry);
        saveList();
    });

    $('#shoppingmode').click(function() {
        if (!shopping) {
            $('input.entry.box, div.button').hide();
            $('input.entry.text').css({ width: "100%", cursor: "default" }).attr("readonly", "");
            $('#titel').css("width", "260px").css("width", "calc(100% - 128px)");
        } else {
            $('input.entry.box, div.button').show();
            $('input.entry.text').css("width", "260px").css("width", "calc(100% - 128px)").removeAttr("readonly");
            $('div.entry').each(shoppingExit);
        }

        shopping = !shopping;
    });

    $('#sort').click(function() {
        list.entries.sort(function (a, b) {
            if (a.state === b.state)
                return a.text > b.text ? 1 : 0;
            return a.state ? 1 : 0;
        });

        saveList();
        showList();

        if (shopping)
            $('#shoppingmode').click().click();
    });
});