﻿namespace Builder
{
    class YoshiBuilder : IBuilder
    {
        YoshiCharacter yoshi;

        public YoshiBuilder()
        {
            yoshi = new YoshiCharacter();
        }

        public YoshiCharacter Result
        {
            get { return yoshi; }
        }

        public IBuilder AddWeapon(Weapon weapon)
        {
            //Yoshi hat keine Waffe
            return this;
        }

        public IBuilder AddArmor(Armor armor)
        {
            //Yoshi hat auch keine Rüstung
            return this;
        }

        public IBuilder AddAbility(Ability ability)
        {
            yoshi.Ability = ability;
            return this;
        }
    }
}
