﻿using System;

namespace EventSystem
{
    class TextBox
    {
        String text;
        ObserverCollection textChanged;

        public TextBox()
        {
            text = String.Empty;
            textChanged = new ObserverCollection();
        }

        public ObserverCollection TextChanged
        {
            get { return textChanged; }
        }

        public String Text
        {
            get { return text; }
            set
            {
                var oldValue = text;
                text = value;
                textChanged.NotifyAll(this, new EventArgs(oldValue, value));
            }
        }

        public void Clear()
        {
            Text = String.Empty;
        }

        public void AppendText(String text)
        {
            Text += text;
        }
    }
}
