﻿using System;
using System.Collections.Generic;

namespace EventSystem
{
    class ObserverCollection
    {
        List<Observer> observers;

        public ObserverCollection()
        {
            observers = new List<Observer>();
        }

        public void Register(Observer observer)
        {
            if (!observers.Contains(observer))
                observers.Add(observer);
        }

        public void Unregister(Observer observer)
        {
            if (observers.Contains(observer))
                observers.Remove(observer);
        }

        public void NotifyAll(Object sender, EventArgs e)
        {
            foreach (var observer in observers)
                observer.Notify(sender, e);
        }
    }
}
