﻿using System;
using System.Collections.Generic;

namespace Dom
{
    class Element : Node
    {
        List<Node> children;

        public Element(String tagName)
        {
            children = new List<Node>();
            TagName = tagName;
        }

        public Node Parent
        {
            get;
            set;
        }

        public IEnumerable<Node> Children
        {
            get { return children; }
        }

        public String TagName
        {
            get;
            private set;
        }

        public override void AddChild(Node child)
        {
            if (child is Element)
            {
                var element = (Element)child;

                if (element.Parent != null)
                    throw new DomException("Multiple parents are not allowed.");

                element.Parent = this;
            }

            children.Add(child);
        }

        public override String ToHtml()
        {
            var content = new String[children.Count];

            for (var i = 0; i < children.Count; i++)
                content[i] = children[i].ToHtml();

            return String.Format("<{0}>{1}</{0}>", TagName, String.Concat(content));
        }
    }
}
