﻿using System;

namespace Dom
{
    class Document : Node
    {
        public Element Root
        {
            get;
            set;
        }

        public override void AddChild(Node child)
        {
            if (Root == null && child is Element)
                Root = (Element)child;
            else
                throw new DomException("A document can only occupy one root element.");
        }

        public override String ToHtml()
        {
            return Root.ToHtml();
        }
    }
}
