#pragma once
#include <mutex>
#include <thread>
#include <list>
#include "runable.h"
#include "workunit.h"
#include "worker.h"

class ThreadPool : public Runable {
public:
	virtual void run();
};

class MyThreadPool {
private:
    std::thread** workers;
    std::list<Worker*> queue;
    std::mutex sync;
    int size;
    bool initialized;

    void kernel(int id);

public:
	MyThreadPool(int size);
    ~MyThreadPool();

    bool getStatus();
    void initialize();
    void shutdown();
    void enqueue(Worker* worker);
};

class WorkerThread : public Worker {
private:
    WorkUnit* unit;

public:
	WorkerThread(WorkUnit* unit);
	virtual ~WorkerThread();

    virtual void run();
    virtual std::string status();
};

class CountdownWorker : public WorkUnit {
private:
    const int target;
    int elapsed;

public:
	CountdownWorker(int time);
    virtual ~CountdownWorker();

    virtual void process();
    virtual std::string status();
};