/* Standard headers */
#include <iostream>

// Help for the program
#include "help.h"
// First exercise (#13)
#include "introduction.h"
// Second exercise (#14)
#include "synchronization.h"
// Third exercise (#15)
#include "threadpool.h"

using namespace std;

int main(int argc, char* argv[]) {
	map<string, Runable*> exercises;
	exercises["introduction"] = new Introduction();
	exercises["synchronization"] = new Synchronization();
	exercises["threadpool"] = new ThreadPool();
	exercises["help"] = new Help(exercises);

	if (argc > 1) {
		for (int i = 1; i < argc; ++i) {
			string arg(argv[i]);
			auto exercise = exercises[arg];

			if (exercise == NULL) {
				cout << "Command " << arg << " not found. Type `help` for a list of commands." << endl;
				return 1;
			}

			exercise->run();
		}
	} else
		cout << "No argument given. Use `help` for a list of commands." << endl;

	return 0;
}