#include "introduction.h"
#include <thread>
#include <chrono>
#include <iostream>

using namespace std;

// Poll on this variable for end of execution detection
volatile bool finished;

void countdown() {
	// Countdown timer
    int time = 10;

    while (time > 0) {
    	cout << "  Still " << time-- << " seconds remaining." << endl;
    	// Wait a second
        this_thread::sleep_for(chrono::milliseconds(1000));
    }

    cout << "  Done!" << endl;
    finished = true;
}

void Introduction::run() {
    cout << "> Running the introduction exercise" << endl;
	finished = false;
	thread t(countdown);
	// Make execution independent of current thread
	t.detach();

	/* Wait for the other thread to finish */
	while (!finished) {
        this_thread::sleep_for(chrono::milliseconds(10));
	}
}