#include <iostream>
#include <sstream>
#include <chrono>
#include "threadpool.h"

using namespace std;

void ThreadPool::run() {
    cout << "> Running the thread pool exercise" << endl;
    MyThreadPool pool(4);
    pool.initialize();

    while (pool.getStatus()) {
    	int timing;
    	cout << "Time in seconds: ";
    	cin >> timing;

    	if (!cin.fail()) {
    		auto countdown = new CountdownWorker(timing);
    		pool.enqueue(new WorkerThread(countdown));
    	}
    }
}

void MyThreadPool::kernel(int id) {
    while (true) {
        Worker* worker = NULL;
        sync.lock();

        if (queue.size() > 0) {
            worker = queue.front();
            queue.pop_front();
        }

        sync.unlock();

        if (worker != NULL) {
            cout << "Running " << worker->status() << " from thread " << id << endl;
            worker->run();
            cout << "Finished " << worker->status() << " from thread " << id << endl;
            delete worker;
        } else
        	this_thread::sleep_for(chrono::milliseconds(10));
    }
}

MyThreadPool::MyThreadPool(int size) : size(size), initialized(false) {
    workers = new thread*[size];
    cout << "Created pool with " << size << " threads" << endl;
}

MyThreadPool::~MyThreadPool() {
	shutdown();
	delete[] workers;
}

bool MyThreadPool::getStatus() {
    return initialized;
}

void MyThreadPool::initialize() {
    if (initialized)
        return;

    for (int i = 0; i < size; ++i) {
        workers[i] = new thread(&MyThreadPool::kernel, this, i);
        workers[i]->detach();
    }

    initialized = true;
    cout << "Pool initialized" << endl;
}

void MyThreadPool::shutdown() {
    if (!initialized)
        return;

    for (int i = 0; i < size; ++i)
        delete workers[i];

    initialized = false;
    cout << "Pool shutdown" << endl;
}

void MyThreadPool::enqueue(Worker* worker) {
    cout << "Queuing worker " << worker->status() << endl;
    sync.lock();
    queue.push_back(worker);
    sync.unlock();
}

WorkerThread::WorkerThread(WorkUnit* unit) : unit(unit) {
}

WorkerThread::~WorkerThread() {
}

void WorkerThread::run() {
    unit->process();
}

string WorkerThread::status() {
	stringstream ss;
	ss << "Worker for unit " << unit->status();
	return ss.str();
}

CountdownWorker::CountdownWorker(int time) : target(time), elapsed(0) {
}

CountdownWorker::~CountdownWorker() {
}

void CountdownWorker::process() {
    while (elapsed != target) {
    	this_thread::sleep_for(chrono::seconds(1));
        elapsed++;
    }
}

string CountdownWorker::status() {
	stringstream ss;
	ss << "Countdown (" << target << "s)";
	return ss.str();
}