﻿using System;
using System.Collections.Generic;
using System.Threading;

namespace MyThreadPool
{
    class MyThreadPool : IDisposable
    {
        Thread[] workers;
        Queue<IWorker> queue;
        Boolean initialized;
        Object sync;

        public MyThreadPool(Int32 size)
        {
            sync = new Object();
            queue = new Queue<IWorker>();
            workers = new Thread[size];
            Logger("Created pool with {0} threads", size);
        }

        public Boolean Running
        {
            get { return initialized; }
        }

        public void Initialize()
        {
            if (initialized)
                return;

            for (var i = 0; i < workers.Length; i++)
            {
                workers[i] = new Thread(PoolKernel);
                workers[i].Start(i);
            }

            initialized = true;
            Logger("Pool initialized");
        }

        public void Shutdown()
        {
            if (!initialized)
                return;

            for (var i = 0; i < workers.Length; i++)
                workers[i].Abort();

            initialized = false;
            Logger("Pool shutdown");
        }

        void PoolKernel(Object id)
        {
            while (true)
            {
                IWorker worker = null;

                lock (sync)
                {
                    if (queue.Count != 0)
                        worker = queue.Dequeue();
                }

                if (worker != null)
                {
                    Logger("Running {0} from thread {1}", worker, id);
                    worker.Run();
                    Logger("Finished {0} from thread {1}", worker, id);
                }
                else
                    Thread.Sleep(10);
            }
        }

        public void Queue(IWorker worker)
        {
            Logger("Queuing worker {0}", worker);
            lock (sync) queue.Enqueue(worker);
        }

        void Logger(String message, params Object[] args)
        {
            Console.WriteLine("{0} {1}.", DateTime.Now.ToString("hh:mm:ss"), String.Format(message, args));
        }

        void IDisposable.Dispose()
        {
            Shutdown();
        }
    }
}
